/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.io.Serializable;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.db.exceptions.FieldIllegalValueException;
import org.apache.empire.exceptions.EmpireException;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlTag
extends UIInput
implements NamingContainer {
    public static String DEFAULT_CONTROL_SEPARATOR_TAG = "td";
    public static String DEFAULT_LABEL_SEPARATOR_CLASS = "eCtlLabel";
    public static String DEFAULT_INPUT_SEPARATOR_CLASS = "eCtlInput";
    private static final Logger log = LoggerFactory.getLogger(ControlTag.class);
    private static final String readOnlyState = "readOnlyState";
    private static final boolean encodeLabel = true;
    protected final TagEncodingHelper helper = new TagEncodingHelper((UIOutput)this, "eInput");
    protected InputControl control = null;
    protected InputControl.InputInfo inpInfo = null;
    protected boolean hasRequiredFlagSet = false;

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    private void saveState() {
        this.getStateHelper().put((Serializable)((Object)readOnlyState), (Object)(this.inpInfo == null ? 1 : 0));
    }

    private boolean initState(FacesContext context) {
        if (!this.helper.isVisible()) {
            return false;
        }
        Boolean ros = (Boolean)this.getStateHelper().get((Serializable)((Object)readOnlyState));
        if (ros != null && ros.booleanValue()) {
            return false;
        }
        this.control = this.helper.getInputControl();
        this.inpInfo = this.helper.getInputInfo(context);
        return this.control != null && this.inpInfo != null;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        if (!this.helper.isVisible()) {
            this.setRendered(false);
            return;
        }
        this.helper.encodeBegin();
        this.control = this.helper.getInputControl();
        boolean isCustomInput = this.isCustomInput();
        ControlSeparatorComponent labelSepTag = null;
        if (this.getChildCount() > 0) {
            labelSepTag = (ControlSeparatorComponent)((Object)this.getChildren().get(0));
        }
        if (labelSepTag == null) {
            labelSepTag = new LabelSeparatorComponent();
            this.getChildren().add(labelSepTag);
        }
        labelSepTag.setRendered(true);
        this.encodeLabel(context, labelSepTag);
        if (isCustomInput) {
            labelSepTag.setRendered(false);
        }
        if (!isCustomInput) {
            ControlSeparatorComponent inputSepTag = null;
            if (this.getChildCount() > 1) {
                inputSepTag = (ControlSeparatorComponent)((Object)this.getChildren().get(1));
            }
            if (inputSepTag == null) {
                inputSepTag = new InputSeparatorComponent();
                this.getChildren().add(inputSepTag);
            }
            this.encodeInput(context, inputSepTag);
        }
        this.saveState();
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (this.isCustomInput()) {
            String tagName = this.helper.getTagAttributeString("tag", DEFAULT_CONTROL_SEPARATOR_TAG);
            String inpClass = this.helper.getTagAttributeString("inputClass", DEFAULT_INPUT_SEPARATOR_CLASS);
            String colSpan = this.helper.getTagAttributeString("colspan");
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement(tagName, (UIComponent)this);
            if (StringUtils.isNotEmpty((String)inpClass)) {
                writer.writeAttribute("class", (Object)inpClass, null);
            }
            if (StringUtils.isNotEmpty((String)colSpan) && tagName.equalsIgnoreCase("td")) {
                writer.writeAttribute("colspan", (Object)colSpan, null);
            }
            super.encodeChildren(context);
            writer.endElement(tagName);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
    }

    public void setRequired(boolean required) {
        super.setRequired(required);
        this.hasRequiredFlagSet = true;
    }

    public boolean isCustomInput() {
        Object custom = this.getAttributes().get("custom");
        if (custom != null) {
            return ObjectUtils.getBoolean(custom);
        }
        return false;
    }

    private void encodeLabel(FacesContext context, UIComponentBase parent) throws IOException {
        HtmlOutputLabel labelComponent = null;
        if (parent.getChildCount() > 0) {
            labelComponent = (HtmlOutputLabel)parent.getChildren().get(0);
            this.helper.updateLabelComponent(context, labelComponent, null);
        }
        if (labelComponent == null) {
            String forInput = this.isCustomInput() ? this.helper.getTagAttributeString("for") : "*";
            labelComponent = this.helper.createLabelComponent(context, forInput, "eLabel", null, true);
            parent.getChildren().add(0, labelComponent);
        }
        parent.encodeAll(context);
    }

    private void encodeInput(FacesContext context, UIComponentBase parent) throws IOException {
        if (this.helper.isRecordReadOnly()) {
            Object valueComp;
            UIComponent uIComponent = valueComp = parent.getChildCount() > 0 ? (UIComponent)parent.getChildren().get(0) : null;
            if (valueComp != null && !(valueComp instanceof ValueOutputComponent)) {
                parent.getChildren().clear();
                valueComp = null;
            }
            if (valueComp == null) {
                valueComp = new ValueOutputComponent();
                parent.getChildren().add(valueComp);
            }
        } else {
            UIComponent valueComp;
            UIComponent uIComponent = valueComp = parent.getChildCount() > 0 ? (UIComponent)parent.getChildren().get(0) : null;
            if (valueComp instanceof ValueOutputComponent) {
                parent.getChildren().clear();
            }
            this.inpInfo = this.helper.getInputInfo(context);
            if (!this.hasRequiredFlagSet) {
                super.setRequired(this.helper.isValueRequired());
            }
            this.control.renderInput((UIComponent)parent, this.inpInfo, context, false);
        }
        parent.encodeAll(context);
    }

    public Object getValue() {
        if (this.helper.getRecord() != null) {
            return this.helper.getDataValue(true);
        }
        Object value = super.getValue();
        return value;
    }

    public Object getSubmittedValue() {
        if (this.control == null || this.inpInfo == null || this.helper.isReadOnly()) {
            return null;
        }
        if (this.getChildCount() <= 1) {
            return null;
        }
        ControlSeparatorComponent inputSepTag = (ControlSeparatorComponent)((Object)this.getChildren().get(1));
        return this.control.getInputValue((UIComponent)inputSepTag, this.inpInfo, true);
    }

    public void validateValue(FacesContext context, Object value) {
        if (this.inpInfo == null || !this.isValid()) {
            return;
        }
        if (ControlTag.isEmpty((Object)value) && this.isPartialSubmit(context)) {
            log.debug("Skipping validation for {} due to Null value.", (Object)this.inpInfo.getColumn().getName());
            return;
        }
        this.inpInfo.validate(value);
        this.setValid(true);
    }

    public void validate(FacesContext context) {
        if (!this.initState(context)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating input for {}.", (Object)this.inpInfo.getColumn().getName());
        }
        try {
            super.validate(context);
        }
        catch (Exception e2) {
            FieldIllegalValueException e2;
            if (!(e2 instanceof EmpireException)) {
                e2 = new FieldIllegalValueException(this.helper.getColumn(), "", (Throwable)e2);
            }
            this.helper.addErrorMessage(context, (Exception)e2);
            this.setValid(false);
        }
    }

    public void updateModel(FacesContext context) {
        if (!this.initState(context)) {
            return;
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        Object value = this.getLocalValue();
        if (ControlTag.isEmpty((Object)value) && this.isPartialSubmit(context) && !this.helper.isTempoaryNullable()) {
            log.debug("Skipping model update for {} due to Null value.", (Object)this.inpInfo.getColumn().getName());
            return;
        }
        log.debug("Updating model input for {}.", (Object)this.inpInfo.getColumn().getName());
        this.inpInfo.setValue(value);
        this.setValue(null);
        this.setLocalValueSet(false);
        ControlSeparatorComponent inputSepTag = (ControlSeparatorComponent)((Object)this.getChildren().get(1));
        this.control.postUpdateModel((UIComponent)inputSepTag, this.inpInfo, context);
    }

    public Column getInputColumn() {
        return this.helper.getColumn();
    }

    public boolean isInputReadOnly() {
        return this.helper.isRecordReadOnly();
    }

    public boolean isInputRequired() {
        return this.helper.isValueRequired();
    }

    private boolean isPartialSubmit(FacesContext context) {
        if (this.hasRequiredFlagSet && !this.isRequired()) {
            return true;
        }
        return this.helper.isPartialSubmit(context);
    }

    public static class ValueOutputComponent
    extends UIComponentBase {
        private final String tagName = "span";

        public String getFamily() {
            return "javax.faces.NamingContainer";
        }

        public void encodeBegin(FacesContext context) throws IOException {
            super.encodeBegin(context);
            UIComponent parent = this.getParent();
            if (!(parent instanceof ControlTag)) {
                parent = parent.getParent();
            }
            if (!(parent instanceof ControlTag)) {
                parent = parent.getParent();
            }
            if (!(parent instanceof ControlTag)) {
                log.error("Invalid parent component for " + ((Object)((Object)this)).getClass().getName());
                return;
            }
            ControlTag controlTag = (ControlTag)parent;
            InputControl control = controlTag.control;
            InputControl.ValueInfo valInfo = controlTag.inpInfo;
            TagEncodingHelper helper = controlTag.helper;
            if (control == null) {
                control = helper.getInputControl();
            }
            if (valInfo == null) {
                valInfo = helper.getValueInfo(context);
            }
            String styleClass = helper.getTagStyleClass("eInpDis");
            String tooltip = helper.getValueTooltip(helper.getTagAttributeString("title"));
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", (UIComponent)this);
            if (StringUtils.isNotEmpty((String)styleClass)) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            if (StringUtils.isNotEmpty((String)tooltip)) {
                writer.writeAttribute("title", (Object)tooltip, null);
            }
            control.renderValue(valInfo, writer);
            writer.endElement("span");
        }
    }

    public static class InputSeparatorComponent
    extends ControlSeparatorComponent {
        @Override
        protected void writeAttributes(ResponseWriter writer, TagEncodingHelper helper, String tagName) throws IOException {
            String colSpan;
            String styleClass = helper.getTagAttributeString("inputClass", DEFAULT_INPUT_SEPARATOR_CLASS);
            if (StringUtils.isNotEmpty((String)styleClass)) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            if (StringUtils.isNotEmpty((String)(colSpan = helper.getTagAttributeString("colspan"))) && tagName.equalsIgnoreCase("td")) {
                writer.writeAttribute("colspan", (Object)colSpan, null);
            }
        }
    }

    public static class LabelSeparatorComponent
    extends ControlSeparatorComponent {
        @Override
        protected void writeAttributes(ResponseWriter writer, TagEncodingHelper helper, String tagName) throws IOException {
            String styleClass = helper.getTagAttributeString("labelClass", DEFAULT_LABEL_SEPARATOR_CLASS);
            if (StringUtils.isNotEmpty((String)styleClass)) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
        }
    }

    public static abstract class ControlSeparatorComponent
    extends UIComponentBase {
        private ControlTag control = null;

        public String getFamily() {
            return "javax.faces.NamingContainer";
        }

        public void encodeBegin(FacesContext context) throws IOException {
            super.encodeBegin(context);
            UIComponent parent = this.getParent();
            if (!(parent instanceof ControlTag)) {
                parent = parent.getParent();
            }
            if (!(parent instanceof ControlTag)) {
                log.error("Invalid parent component for " + ((Object)((Object)this)).getClass().getName());
                return;
            }
            this.control = (ControlTag)parent;
        }

        protected abstract void writeAttributes(ResponseWriter var1, TagEncodingHelper var2, String var3) throws IOException;

        public boolean getRendersChildren() {
            return true;
        }

        public void encodeChildren(FacesContext context) throws IOException {
            if (this.control != null) {
                TagEncodingHelper helper = this.control.helper;
                String tagName = helper.getTagAttributeString("tag", "td");
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement(tagName, (UIComponent)this);
                this.writeAttributes(writer, helper, tagName);
                super.encodeChildren(context);
                writer.endElement(tagName);
            }
        }
    }
}

