/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.el.ELContextListener;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.Behavior;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.validator.Validator;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.jsf2.app.FacesImplementation;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.app.TextResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FacesApplication
extends Application {
    private static final Logger log = LoggerFactory.getLogger(FacesApplication.class);
    private static final String CONNECTION_ATTRIBUTE = "dbConnections";
    public static String APPLICATION_ATTRIBUTE = "app";
    protected TextResolver[] textResolvers = null;
    private String webRoot = null;
    private Application applImpl = null;
    private FacesImplementation facesImpl = null;

    protected FacesApplication() {
        log.info("FacesApplication {0} created", (Object)((Object)((Object)this)).getClass().getName());
    }

    public void setImplementation(FacesImplementation facesImpl, Application applImpl) {
        this.facesImpl = facesImpl;
        this.applImpl = applImpl;
    }

    protected abstract DataSource getAppDataSource(DBDatabase var1);

    protected abstract void init(ServletContext var1);

    protected void initComplete(ServletContext servletContext) {
        this.webRoot = servletContext.getContextPath();
        if (this.textResolvers == null) {
            this.initTextResolvers();
        }
        log.info("FacesApplication initialization complete");
    }

    public void onChangeView(FacesContext fc, String viewId) {
        Map<String, Object> sm = FacesUtils.getSessionMap(fc);
        if (sm != null) {
            sm.remove("pageResources");
        }
    }

    public void addJavascriptCall(FacesContext fc, String function) {
        throw new NotSupportedException((Object)this, "addJavascriptCall");
    }

    public FacesImplementation getFacesImplementation() {
        return this.facesImpl;
    }

    public String getWebRoot() {
        return this.webRoot;
    }

    public Locale getContextLocale(FacesContext ctx) {
        Locale defaultLocale;
        Locale locale = defaultLocale = Locale.getDefault();
        UIViewRoot root = ctx.getViewRoot();
        if (null != root && null == (locale = root.getLocale())) {
            locale = defaultLocale;
        }
        return locale;
    }

    public boolean hasError(FacesContext fc) {
        Iterator msgIterator = fc.getMessages();
        if (msgIterator != null) {
            while (msgIterator.hasNext()) {
                FacesMessage.Severity fms = ((FacesMessage)msgIterator.next()).getSeverity();
                if (fms != FacesMessage.SEVERITY_ERROR && fms != FacesMessage.SEVERITY_FATAL) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPartialSubmit(FacesContext fc) {
        return false;
    }

    public String getPartialSubmitComponentId(FacesContext fc) {
        return null;
    }

    public UIComponent findComponent(FacesContext fc, String componentId, UIComponent nearComponent) {
        if (StringUtils.isEmpty((String)componentId)) {
            throw new InvalidArgumentException("componentId", (Object)componentId);
        }
        UIComponent component = null;
        if (nearComponent != null && (component = nearComponent.findComponent(componentId)) == null) {
            UIComponent nextParent = nearComponent;
            do {
                for (nextParent = nextParent.getParent(); nextParent != null && !(nextParent instanceof NamingContainer); nextParent = nextParent.getParent()) {
                }
            } while (nextParent != null && (component = nextParent.findComponent(componentId)) == null);
        }
        if (component == null) {
            component = FacesApplication.findChildComponent((UIComponent)fc.getViewRoot(), componentId);
        }
        return component;
    }

    public static UIComponent findChildComponent(UIComponent parent, String componentId) {
        UIComponent component = null;
        if (parent.getChildCount() == 0) {
            return null;
        }
        for (UIComponent nextChild : parent.getChildren()) {
            if (nextChild instanceof NamingContainer) {
                component = nextChild.findComponent(componentId);
            }
            if (component == null) {
                component = FacesApplication.findChildComponent(nextChild, componentId);
            }
            if (component == null) continue;
            break;
        }
        return component;
    }

    public String getDefaultControlType(DataType dataType) {
        switch (dataType) {
            case CLOB: {
                return "textarea";
            }
        }
        return "text";
    }

    protected void initTextResolvers() {
        int count = 0;
        Iterator<Locale> locales = this.getSupportedLocales();
        count = 0;
        while (locales.hasNext()) {
            locales.next();
            ++count;
        }
        String messageBundle = this.getMessageBundle();
        this.textResolvers = new TextResolver[count];
        locales = this.getSupportedLocales();
        int i = 0;
        while (locales.hasNext()) {
            Locale locale = locales.next();
            this.textResolvers[i] = new TextResolver(ResourceBundle.getBundle(messageBundle, locale));
            ++i;
        }
    }

    public TextResolver getTextResolver(Locale locale) {
        if (this.textResolvers == null || this.textResolvers.length == 0) {
            throw new NotSupportedException((Object)this, "getTextResolver");
        }
        for (int i = 0; i < this.textResolvers.length; ++i) {
            if (!locale.equals(this.textResolvers[i].getLocale())) continue;
            return this.textResolvers[i];
        }
        return this.textResolvers[0];
    }

    public TextResolver getTextResolver(FacesContext ctx) {
        return this.getTextResolver(this.getContextLocale(ctx));
    }

    public ResourceBundle getResourceBundle(FacesContext fc, String var) {
        if (var.equals("msg")) {
            TextResolver resolver = this.getTextResolver(fc);
            return resolver.getResourceBundle();
        }
        return this.applImpl.getResourceBundle(fc, var);
    }

    protected Connection getConnection(DBDatabase db) {
        try {
            Connection conn = this.getAppDataSource(db).getConnection();
            conn.setAutoCommit(false);
            return conn;
        }
        catch (SQLException e) {
            log.error("Failed to get connection from pool.", (Throwable)e);
            throw new InternalException((Throwable)e);
        }
    }

    protected void releaseConnection(DBDatabase db, Connection conn, boolean commit) {
        try {
            if (conn == null) {
                return;
            }
            if (commit) {
                db.commit(conn);
                log.debug("REQUEST {}: commited.");
            } else {
                db.rollback(conn);
                log.debug("REQUEST {}: rolled back.");
            }
            conn.close();
            if (log.isDebugEnabled()) {
                log.debug("REQUEST {}: returned connection to pool.");
            }
        }
        catch (SQLException e) {
            log.error("Error releasing connection", (Throwable)e);
            e.printStackTrace();
        }
    }

    public Connection getConnectionForRequest(FacesContext fc, DBDatabase db) {
        if (fc == null) {
            throw new InvalidArgumentException("FacesContext", (Object)fc);
        }
        if (db == null) {
            throw new InvalidArgumentException("DBDatabase", (Object)db);
        }
        HashMap<DBDatabase, Connection> connMap = (HashMap<DBDatabase, Connection>)FacesUtils.getRequestAttribute(fc, CONNECTION_ATTRIBUTE);
        if (connMap != null && connMap.containsKey(db)) {
            return (Connection)connMap.get(db);
        }
        Connection conn = this.getConnection(db);
        if (conn == null) {
            return null;
        }
        if (connMap == null) {
            connMap = new HashMap<DBDatabase, Connection>();
            FacesUtils.setRequestAttribute(fc, CONNECTION_ATTRIBUTE, connMap);
        }
        connMap.put(db, conn);
        return conn;
    }

    public void releaseAllConnections(FacesContext fc, boolean commit) {
        Map connMap = (Map)FacesUtils.getRequestAttribute(fc, CONNECTION_ATTRIBUTE);
        if (connMap != null) {
            for (Map.Entry e : connMap.entrySet()) {
                this.releaseConnection((DBDatabase)e.getKey(), (Connection)e.getValue(), commit);
            }
            FacesUtils.setRequestAttribute(fc, CONNECTION_ATTRIBUTE, null);
        }
    }

    public void releaseAllConnections(FacesContext fc) {
        this.releaseAllConnections(fc, !this.hasError(fc));
    }

    public void releaseConnection(FacesContext fc, DBDatabase db, boolean commit) {
        Map connMap = (Map)FacesUtils.getRequestAttribute(fc, CONNECTION_ATTRIBUTE);
        if (connMap != null && connMap.containsKey(db)) {
            this.releaseConnection(db, (Connection)connMap.get(db), commit);
            connMap.remove(db);
            if (connMap.size() == 0) {
                FacesUtils.setRequestAttribute(fc, CONNECTION_ATTRIBUTE, null);
            }
        }
    }

    public void releaseConnection(FacesContext fc, DBDatabase db) {
        this.releaseConnection(fc, db, !this.hasError(fc));
    }

    public void addBehavior(String behaviorId, String behaviorClass) {
        this.applImpl.addBehavior(behaviorId, behaviorClass);
    }

    public void addComponent(String componentType, String componentClass) {
        this.applImpl.addComponent(componentType, componentClass);
    }

    public void addConverter(Class<?> targetClass, String converterClass) {
        this.applImpl.addConverter(targetClass, converterClass);
    }

    public void addConverter(String converterId, String converterClass) {
        this.applImpl.addConverter(converterId, converterClass);
    }

    public void addDefaultValidatorId(String validatorId) {
        this.applImpl.addDefaultValidatorId(validatorId);
    }

    public void addELContextListener(ELContextListener listener) {
        this.applImpl.addELContextListener(listener);
    }

    public void addELResolver(ELResolver resolver) {
        this.applImpl.addELResolver(resolver);
    }

    public void addValidator(String validatorId, String validatorClass) {
        this.applImpl.addValidator(validatorId, validatorClass);
    }

    public Behavior createBehavior(String behaviorId) throws FacesException {
        return this.applImpl.createBehavior(behaviorId);
    }

    public UIComponent createComponent(FacesContext context, Resource componentResource) {
        return this.applImpl.createComponent(context, componentResource);
    }

    public UIComponent createComponent(FacesContext context, String componentType, String rendererType) {
        return this.applImpl.createComponent(context, componentType, rendererType);
    }

    public UIComponent createComponent(String componentType) throws FacesException {
        return this.applImpl.createComponent(componentType);
    }

    public UIComponent createComponent(ValueBinding componentBinding, FacesContext context, String componentType) throws FacesException {
        return this.applImpl.createComponent(componentBinding, context, componentType);
    }

    public UIComponent createComponent(ValueExpression componentExpression, FacesContext context, String componentType) throws FacesException {
        return this.applImpl.createComponent(componentExpression, context, componentType);
    }

    public UIComponent createComponent(ValueExpression componentExpression, FacesContext context, String componentType, String rendererType) {
        return this.applImpl.createComponent(componentExpression, context, componentType, rendererType);
    }

    public Converter createConverter(Class<?> targetClass) {
        return this.applImpl.createConverter(targetClass);
    }

    public Converter createConverter(String converterId) {
        return this.applImpl.createConverter(converterId);
    }

    public MethodBinding createMethodBinding(String ref, Class<?>[] params) throws ReferenceSyntaxException {
        return this.applImpl.createMethodBinding(ref, (Class[])params);
    }

    public Validator createValidator(String validatorId) throws FacesException {
        return this.applImpl.createValidator(validatorId);
    }

    public ValueBinding createValueBinding(String ref) throws ReferenceSyntaxException {
        return this.applImpl.createValueBinding(ref);
    }

    public <T> T evaluateExpressionGet(FacesContext context, String expression, Class<? extends T> expectedType) throws ELException {
        return (T)this.applImpl.evaluateExpressionGet(context, expression, expectedType);
    }

    public ActionListener getActionListener() {
        return this.applImpl.getActionListener();
    }

    public Iterator<String> getBehaviorIds() {
        return this.applImpl.getBehaviorIds();
    }

    public Iterator<String> getComponentTypes() {
        return this.applImpl.getComponentTypes();
    }

    public Iterator<String> getConverterIds() {
        return this.applImpl.getConverterIds();
    }

    public Iterator<Class<?>> getConverterTypes() {
        return this.applImpl.getConverterTypes();
    }

    public Locale getDefaultLocale() {
        return this.applImpl.getDefaultLocale();
    }

    public String getDefaultRenderKitId() {
        return this.applImpl.getDefaultRenderKitId();
    }

    public Map<String, String> getDefaultValidatorInfo() {
        return this.applImpl.getDefaultValidatorInfo();
    }

    public ELContextListener[] getELContextListeners() {
        return this.applImpl.getELContextListeners();
    }

    public ELResolver getELResolver() {
        return this.applImpl.getELResolver();
    }

    public ExpressionFactory getExpressionFactory() {
        return this.applImpl.getExpressionFactory();
    }

    public String getMessageBundle() {
        return this.applImpl.getMessageBundle();
    }

    public NavigationHandler getNavigationHandler() {
        return this.applImpl.getNavigationHandler();
    }

    public ProjectStage getProjectStage() {
        return this.applImpl.getProjectStage();
    }

    public PropertyResolver getPropertyResolver() {
        return this.applImpl.getPropertyResolver();
    }

    public ResourceHandler getResourceHandler() {
        return this.applImpl.getResourceHandler();
    }

    public StateManager getStateManager() {
        return this.applImpl.getStateManager();
    }

    public Iterator<Locale> getSupportedLocales() {
        return this.applImpl.getSupportedLocales();
    }

    public Iterator<String> getValidatorIds() {
        return this.applImpl.getValidatorIds();
    }

    public VariableResolver getVariableResolver() {
        return this.applImpl.getVariableResolver();
    }

    public ViewHandler getViewHandler() {
        return this.applImpl.getViewHandler();
    }

    public void publishEvent(FacesContext facesContext, Class<? extends SystemEvent> systemEventClass, Class<?> sourceBaseType, Object source) {
        this.applImpl.publishEvent(facesContext, systemEventClass, sourceBaseType, source);
    }

    public void publishEvent(FacesContext facesContext, Class<? extends SystemEvent> systemEventClass, Object source) {
        this.applImpl.publishEvent(facesContext, systemEventClass, source);
    }

    public void removeELContextListener(ELContextListener listener) {
        this.applImpl.removeELContextListener(listener);
    }

    public void setActionListener(ActionListener listener) {
        this.applImpl.setActionListener(listener);
    }

    public void setDefaultLocale(Locale locale) {
        this.applImpl.setDefaultLocale(locale);
    }

    public void setDefaultRenderKitId(String renderKitId) {
        this.applImpl.setDefaultRenderKitId(renderKitId);
    }

    public void setMessageBundle(String bundle) {
        this.applImpl.setMessageBundle(bundle);
    }

    public void setNavigationHandler(NavigationHandler handler) {
        this.applImpl.setNavigationHandler(handler);
    }

    public void setPropertyResolver(PropertyResolver resolver) {
        this.applImpl.setPropertyResolver(resolver);
    }

    public void setResourceHandler(ResourceHandler resourceHandler) {
        this.applImpl.setResourceHandler(resourceHandler);
    }

    public void setStateManager(StateManager manager) {
        this.applImpl.setStateManager(manager);
    }

    public void setSupportedLocales(Collection<Locale> locales) {
        this.applImpl.setSupportedLocales(locales);
    }

    public void setVariableResolver(VariableResolver resolver) {
        this.applImpl.setVariableResolver(resolver);
    }

    public void setViewHandler(ViewHandler handler) {
        this.applImpl.setViewHandler(handler);
    }

    public void subscribeToEvent(Class<? extends SystemEvent> systemEventClass, Class<?> sourceClass, SystemEventListener listener) {
        this.applImpl.subscribeToEvent(systemEventClass, sourceClass, listener);
    }

    public void subscribeToEvent(Class<? extends SystemEvent> systemEventClass, SystemEventListener listener) {
        this.applImpl.subscribeToEvent(systemEventClass, listener);
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> systemEventClass, Class<?> sourceClass, SystemEventListener listener) {
        this.applImpl.unsubscribeFromEvent(systemEventClass, sourceClass, listener);
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> systemEventClass, SystemEventListener listener) {
        this.applImpl.unsubscribeFromEvent(systemEventClass, listener);
    }
}

