/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.servlet.ServletContext;
import org.apache.empire.jsf2.app.FacesApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppStartupListener
implements SystemEventListener {
    private static final Logger log = LoggerFactory.getLogger(AppStartupListener.class);

    public boolean isListenerForSource(Object source) {
        return source instanceof Application;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        log.info("ApplicationStartupListener:processEvent");
        if (event instanceof PostConstructApplicationEvent) {
            Application app = ((PostConstructApplicationEvent)event).getApplication();
            if (!(app instanceof FacesApplication)) {
                throw new AbortProcessingException("Error: Application is not a " + FacesApplication.class.getName() + " instance. Please create a ApplicationFactory!");
            }
            ServletContext servletContext = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
            FacesApplication jsfApp = (FacesApplication)app;
            jsfApp.init(servletContext);
            if (servletContext.getAttribute(FacesApplication.APPLICATION_ATTRIBUTE) != null) {
                log.warn("WARNING: Ambiguous application definition. An object of name '{}' already exists on application scope!", (Object)FacesApplication.APPLICATION_ATTRIBUTE);
            }
            servletContext.setAttribute(FacesApplication.APPLICATION_ATTRIBUTE, (Object)jsfApp);
            jsfApp.initComplete(servletContext);
        } else if (event instanceof PreDestroyApplicationEvent) {
            log.info("Processing PreDestroyApplicationEvent");
        }
    }
}

