/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pages;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.jsf2.pages.Page;

public class PageElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Page page;
    private final String propertyName;

    protected PageElement(Page page, String propertyName) {
        if (page == null) {
            throw new InvalidArgumentException("page", (Object)page);
        }
        if (StringUtils.isEmpty((String)propertyName)) {
            throw new InvalidArgumentException("propertyName", (Object)propertyName);
        }
        this.page = page;
        this.propertyName = propertyName;
        page.registerPageElement(this);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Page getPage() {
        return this.page;
    }

    protected void onInitPage() {
    }

    protected void onRefreshPage() {
    }

    protected <T> T getSessionObject(Class<T> type) {
        String beanName = this.page.getPageName() + "." + this.propertyName + "." + type.getSimpleName();
        Map map = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        return (T)map.get(beanName);
    }

    protected <T> void setSessionObject(Class<T> type, T object) {
        String beanName = this.page.getPageName() + "." + this.propertyName + "." + type.getSimpleName();
        Map map = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        if (object != null) {
            map.put(beanName, object);
        } else {
            map.remove(beanName);
        }
    }

    protected <T> void removeSessionObject(Class<T> type) {
        this.setSessionObject(type, null);
    }

    public Connection getConnection(DBDatabase db) {
        return this.page.getConnection(db);
    }

    public Connection getConnection(DBObject dbo) {
        if (dbo == null) {
            throw new InvalidArgumentException("dbo", (Object)dbo);
        }
        return this.page.getConnection(dbo.getDatabase());
    }
}

