/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.io.IOException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataType;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextInputControl
extends InputControl {
    private static final Logger log = LoggerFactory.getLogger(TextInputControl.class);
    public static final String NAME = "text";
    public static final String FORMAT_UNIT = "unit:";
    public static final String FORMAT_UNIT_ATTRIBUTE = "format:unit";
    public static final String DATE_FORMAT = "date-format:";
    public static final String DATE_FORMAT_ATTRIBUTE = "format:date";
    private Class<? extends HtmlInputText> inputComponentClass;

    public TextInputControl(String name, Class<? extends HtmlInputText> inputComponentClass) {
        super(name);
        this.inputComponentClass = inputComponentClass;
    }

    public TextInputControl(String name) {
        this(name, HtmlInputText.class);
    }

    public TextInputControl() {
        this(NAME, HtmlInputText.class);
    }

    @Override
    protected void createInputComponents(UIComponent parent, InputControl.InputInfo ii, FacesContext context, List<UIComponent> compList) {
        HtmlInputText input;
        if (compList.size() == 0) {
            String hint;
            try {
                input = this.inputComponentClass.newInstance();
            }
            catch (InstantiationException e1) {
                throw new InternalException((Throwable)e1);
            }
            catch (IllegalAccessException e2) {
                throw new InternalException((Throwable)e2);
            }
            this.copyAttributes(parent, ii, (UIInput)input);
            input.setLang(ii.getLocale().getLanguage());
            int maxLength = this.getMaxInputLength(ii.getColumn());
            if (maxLength > 0) {
                input.setMaxlength(maxLength);
            }
            compList.add((UIComponent)input);
            String unit = this.getUnitString(ii);
            if (StringUtils.isNotEmpty((String)unit)) {
                compList.add(this.createUnitLabel("eUnit", ii, unit));
            }
            if (StringUtils.isNotEmpty((String)(hint = StringUtils.toString((Object)ii.getAttribute("hint")))) && !ii.isDisabled()) {
                compList.add(this.createUnitLabel("eInputHint", ii, hint));
            }
        } else {
            UIComponent comp = compList.get(0);
            if (!(comp instanceof HtmlInputText)) {
                throw new UnexpectedReturnValueException((Object)comp.getClass().getName(), "compList.get");
            }
            input = (HtmlInputText)comp;
        }
        Object dis = ii.getAttributeEx("disabled");
        if (dis != null) {
            input.setDisabled(ObjectUtils.getBoolean((Object)dis));
        }
        if (!ObjectUtils.getBoolean((Object)dis)) {
            input.setReadonly(ii.isFieldReadOnly());
        }
        this.addRemoveDisabledStyle((UIInput)input, input.isDisabled() || input.isReadonly());
        this.addRemoveInvalidStyle((UIInput)input, ii.hasError());
        this.setInputValue((UIInput)input, ii);
    }

    protected UIComponent createUnitLabel(String tagStyle, InputControl.InputInfo ii, String value) {
        HtmlOutputText text = new HtmlOutputText();
        text.setValue((Object)value);
        HtmlPanelGroup span = new HtmlPanelGroup();
        String styleClass = TagEncodingHelper.getTagStyleClass(tagStyle, TagEncodingHelper.getDataTypeClass(ii.getColumn().getDataType()), null, null);
        span.getAttributes().put("styleClass", styleClass);
        span.getChildren().add(text);
        return span;
    }

    @Override
    protected Object parseInputValue(String value, InputControl.InputInfo ii) {
        Column column;
        DataType type;
        if (!this.hasFormatOption(ii, "notrim")) {
            value = value.trim();
        }
        if ((type = (column = ii.getColumn()).getDataType()).isText()) {
            return value;
        }
        if (type == DataType.INTEGER) {
            NumberFormat nf = NumberFormat.getIntegerInstance(ii.getLocale());
            return this.parseNumber(value, nf);
        }
        if (type == DataType.DECIMAL || type == DataType.FLOAT) {
            NumberFormat nf = NumberFormat.getNumberInstance(ii.getLocale());
            return this.parseNumber(value, nf);
        }
        if (type == DataType.DATE || type == DataType.DATETIME) {
            return this.parseDate(value, this.getDateFormat(column.getDataType(), ii, column));
        }
        if (type == DataType.BOOL) {
            return ObjectUtils.getBoolean((Object)value);
        }
        if (type == DataType.AUTOINC) {
            log.error("Autoinc-value cannot be changed.");
            return null;
        }
        return value;
    }

    @Override
    protected String formatValue(Object value, InputControl.ValueInfo vi) {
        Options options = vi.getOptions();
        if (options != null && !options.isEmpty()) {
            String text = options.get(value);
            if (text != null) {
                return vi.getText(text);
            }
            log.error("The element '" + String.valueOf(value) + "' is not part of the supplied option list.");
        }
        if (value == null) {
            Object nullValue = this.getFormatOption(vi, "null:", "format:null");
            if (nullValue != null) {
                return this.formatValue(nullValue, vi);
            }
            return "";
        }
        Column column = vi.getColumn();
        DataType dataType = this.getValueType(value, column != null ? column.getDataType() : DataType.UNKNOWN);
        if (dataType == DataType.TEXT || dataType == DataType.UNKNOWN) {
            String s = String.valueOf(value);
            if (this.hasFormatOption(vi, "noencode")) {
                return s;
            }
            return this.escapeHTML(s);
        }
        if (dataType == DataType.INTEGER || dataType == DataType.AUTOINC) {
            NumberFormat nf = NumberFormat.getIntegerInstance(vi.getLocale());
            nf.setGroupingUsed(false);
            return nf.format(value);
        }
        if (dataType == DataType.DECIMAL || dataType == DataType.FLOAT) {
            NumberFormat nf = this.getNumberFormat(dataType, vi.getLocale(), column);
            return nf.format(value);
        }
        if (dataType == DataType.DATE || dataType == DataType.DATETIME) {
            if (dataType == DataType.DATETIME && this.hasFormatOption(vi, "notime")) {
                dataType = DataType.DATE;
            }
            DateFormat df = this.getDateFormat(dataType, vi, column);
            return df.format(value);
        }
        return this.escapeHTML(String.valueOf(value));
    }

    @Override
    protected Object formatInputValue(Object value, InputControl.InputInfo ii) {
        if (value == null) {
            return "";
        }
        Options options = ii.getOptions();
        if (options != null && !options.isEmpty()) {
            return value;
        }
        return this.formatValue(value, ii);
    }

    @Override
    public void renderValue(InputControl.ValueInfo vi, ResponseWriter writer) throws IOException {
        String text = this.formatValue(vi);
        if (StringUtils.isEmpty((String)text)) {
            writer.append((CharSequence)"&nbsp;");
            return;
        }
        writer.append((CharSequence)text);
        String unit = this.getUnitString(vi);
        if (StringUtils.isNotEmpty((String)unit)) {
            writer.append((CharSequence)" ");
            writer.append((CharSequence)unit);
        }
    }

    protected int getMaxInputLength(Column col) {
        DataType type = col.getDataType();
        if (type == DataType.CHAR || type == DataType.TEXT) {
            return (int)Math.round(col.getSize());
        }
        if (type == DataType.AUTOINC || type == DataType.INTEGER) {
            return 10;
        }
        if (type == DataType.FLOAT) {
            return 18;
        }
        if (type == DataType.DECIMAL) {
            Object minVal;
            Object groupSep;
            double size = col.getSize();
            int prec = (int)Math.round(size);
            if (prec == 0) {
                return 0;
            }
            int len = prec;
            int scale = (int)(size * 10.0) - prec * 10;
            if (scale > 0) {
                ++len;
            }
            if ((groupSep = col.getAttribute("numberGroupSeparator")) != null && ObjectUtils.getBoolean((Object)groupSep)) {
                len += (prec - scale - 1) / 3;
            }
            if ((minVal = col.getAttribute("minValue")) == null || ObjectUtils.getInteger((Object)minVal) < 0) {
                ++len;
            }
            return len;
        }
        if (type == DataType.BOOL) {
            return 1;
        }
        if (type == DataType.DATE) {
            return 10;
        }
        if (type == DataType.DATETIME) {
            return 16;
        }
        if (type == DataType.CLOB) {
            return 0;
        }
        log.info("No max-length available for data type {}.", (Object)type);
        return 0;
    }

    protected DataType getValueType(Object value, DataType desiredType) {
        if (value instanceof String) {
            return DataType.TEXT;
        }
        if (value instanceof Number) {
            if (desiredType == DataType.AUTOINC || desiredType == DataType.INTEGER || desiredType == DataType.FLOAT || desiredType == DataType.DECIMAL) {
                return desiredType;
            }
            if (value instanceof Integer || value instanceof Long || value instanceof Short) {
                return DataType.INTEGER;
            }
            if (value instanceof Float || value instanceof Double) {
                return DataType.FLOAT;
            }
            return DataType.DECIMAL;
        }
        if (value instanceof Date) {
            if (desiredType == DataType.DATETIME || desiredType == DataType.DATE) {
                return desiredType;
            }
            if (value instanceof Timestamp) {
                return DataType.DATETIME;
            }
            return DataType.DATE;
        }
        if (value instanceof Boolean) {
            return DataType.BOOL;
        }
        return DataType.UNKNOWN;
    }

    protected NumberFormat getNumberFormat(DataType dataType, Locale locale, Column column) {
        if (column == null) {
            return NumberFormat.getNumberInstance(locale);
        }
        String type = StringUtils.valueOf((Object)column.getAttribute("numberType"));
        NumberFormat nf = null;
        nf = type.equalsIgnoreCase("Integer") ? NumberFormat.getIntegerInstance(locale) : NumberFormat.getNumberInstance(locale);
        Object groupSep = column.getAttribute("numberGroupSeparator");
        nf.setGroupingUsed(groupSep != null && ObjectUtils.getBoolean((Object)groupSep));
        Object fractDigit = column.getAttribute("numberFractionDigits");
        if (fractDigit != null) {
            int fractionDigits = ObjectUtils.getInteger((Object)fractDigit);
            nf.setMaximumFractionDigits(fractionDigits);
            nf.setMinimumFractionDigits(fractionDigits);
        }
        return nf;
    }

    protected DateFormat getDateFormat(DataType dataType, InputControl.ValueInfo vi, Column column) {
        String pattern = null;
        int type = 2;
        String format = this.getFormatString(vi, DATE_FORMAT, DATE_FORMAT_ATTRIBUTE);
        if (format != null) {
            if (StringUtils.compareEqual((String)format, (String)"full", (boolean)true)) {
                type = 0;
            } else if (StringUtils.compareEqual((String)format, (String)"medium", (boolean)true)) {
                type = 2;
            } else if (StringUtils.compareEqual((String)format, (String)"short", (boolean)true)) {
                type = 3;
            } else if (StringUtils.compareEqual((String)format, (String)"long", (boolean)true)) {
                type = 1;
            } else {
                pattern = format;
            }
        }
        DateFormat df = StringUtils.isNotEmpty(pattern) ? new SimpleDateFormat(pattern, vi.getLocale()) : (dataType == DataType.DATE ? DateFormat.getDateInstance(type, vi.getLocale()) : DateFormat.getDateTimeInstance(type, type, vi.getLocale()));
        return df;
    }

    private String getUnitString(InputControl.ValueInfo vi) {
        String numberType;
        String format = this.getFormatString(vi, FORMAT_UNIT, FORMAT_UNIT_ATTRIBUTE);
        if (format != null) {
            return format;
        }
        Column column = vi.getColumn();
        if (column != null && column.getDataType() == DataType.DECIMAL && (numberType = StringUtils.toString((Object)column.getAttribute("numberType"))) != null) {
            if (numberType.equalsIgnoreCase("Currency")) {
                String currencyCode = StringUtils.toString((Object)column.getAttribute("currencyCode"));
                if (currencyCode != null) {
                    Currency currency = Currency.getInstance(currencyCode);
                    return currency != null ? currency.getSymbol() : null;
                }
            } else if (numberType.equalsIgnoreCase("Percent")) {
                return "%";
            }
        }
        return null;
    }

    protected Object parseNumber(String s, NumberFormat nf) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) < 'A') continue;
            throw new NumberFormatException("Not a number: " + s);
        }
        try {
            return nf.parseObject(s);
        }
        catch (ParseException pe) {
            throw new NumberFormatException("Not a number: " + s + " Exception: " + pe.toString());
        }
    }

    protected Object parseDate(String s, DateFormat df) {
        try {
            df.setLenient(true);
            return df.parseObject(s);
        }
        catch (ParseException pe) {
            throw new RuntimeException("Invalid date format: " + s, pe);
        }
    }
}

