/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.apache.empire.jsf2.controls.SelectInputControl;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectTag
extends UIInput
implements NamingContainer {
    private static final Logger log = LoggerFactory.getLogger(SelectTag.class);

    public SelectTag() {
        log.trace("component select created");
    }

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        UIInput inputComponent = null;
        TextResolver textResolver = FacesUtils.getTextResolver(context);
        if (this.getChildCount() > 0) {
            inputComponent = this.getInputComponent();
            if (inputComponent instanceof HtmlSelectOneMenu) {
                SelectInputControl control = (SelectInputControl)InputControlManager.getControl("select");
                boolean disabled = this.isDisabled();
                ((HtmlSelectOneMenu)inputComponent).setDisabled(disabled);
                Options options = this.getOptionList();
                boolean hasEmpty = this.isAllowNull() && !options.contains((Object)"");
                control.syncOptions((HtmlSelectOneMenu)inputComponent, textResolver, options, hasEmpty, this.getNullText());
                this.setInputValue((HtmlSelectOneMenu)inputComponent);
            } else {
                log.warn("WARN: Unexpected child node for {}! Child item type is {}.", (Object)((Object)((Object)this)).getClass().getName(), (Object)inputComponent.getClass().getName());
                inputComponent = null;
            }
        }
        if (inputComponent == null) {
            inputComponent = this.createSelectOneMenu(textResolver);
            this.getChildren().add(0, inputComponent);
        }
        inputComponent.encodeAll(context);
        super.encodeBegin(context);
    }

    public void updateModel(FacesContext context) {
        if (!this.isDisabled()) {
            Object value;
            UIInput inputComponent = this.getInputComponent();
            Object object = value = inputComponent == null ? "" : inputComponent.getValue();
            if (value == null) {
                value = "";
            }
            this.setValue(value);
        }
        super.updateModel(context);
    }

    public void validate(FacesContext context) {
        UIInput inputComponent = this.getInputComponent();
        if (inputComponent == null) {
            return;
        }
        if (!inputComponent.isValid() || this.isDisabled()) {
            return;
        }
        super.validate(context);
    }

    private UIInput getInputComponent() {
        if (this.getChildren().size() == 0) {
            return null;
        }
        return (UIInput)this.getChildren().get(0);
    }

    private Options getOptionList() {
        Object options = this.getAttributes().get("options");
        if (!(options instanceof Options)) {
            return new Options();
        }
        return (Options)options;
    }

    private boolean isAllowNull() {
        Object allowNull = this.getAttributes().get("allowNull");
        return ObjectUtils.getBoolean(allowNull);
    }

    private String getNullText() {
        Object nullText = this.getAttributes().get("nullText");
        return StringUtils.toString(nullText, (String)"");
    }

    private boolean isDisabled() {
        Object disabled = this.getAttributes().get("disabled");
        return ObjectUtils.getBoolean(disabled);
    }

    private UIInput createSelectOneMenu(TextResolver textResolver) {
        SelectInputControl control = (SelectInputControl)InputControlManager.getControl("select");
        HtmlSelectOneMenu input = control.createMenuComponent((UIComponent)this);
        String userStyle = StringUtils.toString(this.getAttributes().get("styleClass"));
        String cssStyle = TagEncodingHelper.getTagStyleClass("eSelect", null, null, userStyle);
        input.setStyleClass(cssStyle);
        this.copyAttributes(input);
        Options options = this.getOptionList();
        boolean addEmpty = this.isAllowNull() && !options.contains((Object)"");
        control.initOptions(input, textResolver, options, addEmpty, this.getNullText());
        boolean disabled = this.isDisabled();
        input.setDisabled(disabled);
        control.addRemoveDisabledStyle((UIInput)input, disabled);
        this.setInputValue(input);
        return input;
    }

    private void setInputValue(HtmlSelectOneMenu input) {
        Object value = this.getValue();
        if (value != null) {
            value = value.getClass().isEnum() ? ((Enum)value).name() : String.valueOf(value);
        }
        input.setValue(value);
    }

    private void copyAttributes(HtmlSelectOneMenu input) {
        Map attr = this.getAttributes();
        Object value = attr.get("style");
        if (value != null) {
            input.setStyle(StringUtils.toString(value));
        }
        if ((value = attr.get("tabindex")) != null) {
            input.setTabindex(StringUtils.toString(value));
        }
        if ((value = attr.get("onchange")) != null) {
            input.setOnchange(StringUtils.toString(value));
        }
    }
}

