/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItem;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.Options;
import org.apache.empire.data.Column;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.controls.InputControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectInputControl
extends InputControl {
    private static final Logger log = LoggerFactory.getLogger(SelectInputControl.class);
    public static final String COLATTR_ABBR_OPTIONS = "ABBR_OPTIONS";
    public static final String NAME = "select";
    private Class<? extends HtmlSelectOneMenu> inputComponentClass;

    public SelectInputControl(Class<? extends HtmlSelectOneMenu> inputComponentClass) {
        super(NAME);
        this.inputComponentClass = inputComponentClass;
    }

    public SelectInputControl() {
        this(HtmlSelectOneMenu.class);
    }

    public HtmlSelectOneMenu createMenuComponent(UIComponent parent) {
        try {
            return this.inputComponentClass.newInstance();
        }
        catch (InstantiationException e1) {
            throw new InternalException((Throwable)e1);
        }
        catch (IllegalAccessException e2) {
            throw new InternalException((Throwable)e2);
        }
    }

    @Override
    protected void createInputComponents(UIComponent parent, InputControl.InputInfo ii, FacesContext context, List<UIComponent> compList) {
        HtmlSelectOneMenu input;
        if (compList.size() == 0) {
            try {
                input = this.inputComponentClass.newInstance();
            }
            catch (InstantiationException e1) {
                throw new InternalException((Throwable)e1);
            }
            catch (IllegalAccessException e2) {
                throw new InternalException((Throwable)e2);
            }
            this.copyAttributes(parent, ii, (UIInput)input);
            boolean disabled = ii.isDisabled();
            input.setDisabled(disabled);
            Options options = ii.getOptions();
            boolean hasEmpty = !ii.isRequired() && (!disabled || !ii.getColumn().isRequired()) && !options.contains((Object)"");
            String nullText = hasEmpty ? this.getNullText(ii) : "";
            this.initOptions(input, ii.getTextResolver(), options, hasEmpty, nullText);
            compList.add((UIComponent)input);
        } else {
            UIComponent comp = compList.get(0);
            if (!(comp instanceof HtmlSelectOneMenu)) {
                throw new UnexpectedReturnValueException((Object)comp.getClass().getName(), "compList.get");
            }
            input = (HtmlSelectOneMenu)comp;
            boolean disabled = ii.isDisabled();
            input.setDisabled(disabled);
            Options options = ii.getOptions();
            boolean hasEmpty = !ii.isRequired() && (!disabled || !ii.getColumn().isRequired()) && !options.contains((Object)"");
            String nullText = hasEmpty ? this.getNullText(ii) : "";
            this.syncOptions(input, ii.getTextResolver(), options, hasEmpty, nullText);
        }
        this.addRemoveDisabledStyle((UIInput)input, input.isDisabled());
        this.addRemoveInvalidStyle((UIInput)input, ii.hasError());
        this.setInputValue((UIInput)input, ii);
    }

    public void initOptions(HtmlSelectOneMenu input, TextResolver textResolver, Options options, boolean addEmpty, String nullText) {
        if (addEmpty) {
            this.addSelectItem((UIComponent)input, textResolver, new OptionEntry((Object)"", nullText));
        }
        if (options != null && options.size() > 0) {
            for (OptionEntry e : options) {
                this.addSelectItem((UIComponent)input, textResolver, e);
            }
        }
    }

    public void syncOptions(HtmlSelectOneMenu input, TextResolver textResolver, Options options, boolean hasEmpty, String nullText) {
        Iterator ioe = options.iterator();
        OptionEntry oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
        List childList = input.getChildren();
        Iterator ico = childList.iterator();
        int lastIndex = 0;
        while (ico.hasNext()) {
            UISelectItem si;
            Object ov;
            ++lastIndex;
            UIComponent co = (UIComponent)ico.next();
            if (!(co instanceof UISelectItem) || ObjectUtils.isEmpty((Object)(ov = (si = (UISelectItem)co).getItemValue())) && hasEmpty) continue;
            if (oe == null) {
                --lastIndex;
                for (int index = childList.size() - 1; index >= lastIndex; --index) {
                    childList.remove(index);
                }
                return;
            }
            if (ObjectUtils.compareEqual((Object)ov, (Object)oe.getValue())) {
                oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
                continue;
            }
            input.getChildren().clear();
            if (hasEmpty) {
                this.addSelectItem((UIComponent)input, textResolver, new OptionEntry((Object)"", nullText));
            }
            for (OptionEntry e : options) {
                this.addSelectItem((UIComponent)input, textResolver, e);
            }
            return;
        }
        while (oe != null) {
            this.addSelectItem((UIComponent)input, textResolver, oe);
            oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
        }
    }

    public void addSelectItem(UIComponent input, TextResolver textResolver, OptionEntry e) {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)e.getValueString());
        String text = e.getText();
        text = textResolver.resolveText(text);
        selectItem.setItemLabel(text);
        input.getChildren().add(selectItem);
    }

    private String getNullText(InputControl.InputInfo ii) {
        String nullText = this.getFormatString(ii, "null:", "format:null");
        return nullText != null ? ii.getText(nullText) : "";
    }

    @Override
    protected String formatValue(Object value, InputControl.ValueInfo vi) {
        Object attrValue;
        Column column;
        if (vi.getOptions() == null) {
            log.warn("Select field {} has no Option list attached!", (Object)vi.getColumn().getName());
            return super.formatValue(value, vi);
        }
        if (this.hasFormatOption(vi, "short") && (column = vi.getColumn()) != null && (attrValue = column.getAttribute(COLATTR_ABBR_OPTIONS)) instanceof Options) {
            String text = ((Options)attrValue).get(value);
            if (text != null) {
                return vi.getText(text);
            }
            log.error("The element '" + String.valueOf(value) + "' is not part of the supplied option list.");
        }
        return super.formatValue(value, vi);
    }
}

