/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.jsf2.utils.TagEncodingHelper;

public class MenuListTag
extends UIOutput
implements NamingContainer {
    private final TagEncodingHelper helper = new TagEncodingHelper(this, "eMenuList");
    private String currentId = null;
    private String currentClass = null;
    private String disabledClass = null;
    private String expandedClass = null;
    private String defaultItemClass = null;
    private int level = 0;

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.initMenuAttributes();
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("ul", (UIComponent)this);
        this.helper.writeAttribute(writer, "class", this.helper.getTagAttributeString("styleClass"));
        this.helper.writeAttribute(writer, "style", this.helper.getTagAttributeString("style"));
    }

    public void encodeChildren(FacesContext context) throws IOException {
        super.encodeChildren(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("ul");
    }

    private void initMenuAttributes() {
        this.currentId = this.helper.getTagAttributeString("currentId");
        this.currentClass = this.helper.getTagAttributeString("currentClass");
        this.disabledClass = this.helper.getTagAttributeString("disabledClass");
        this.expandedClass = this.helper.getTagAttributeString("expandedClass");
        this.defaultItemClass = this.helper.getTagAttributeString("defaultItemClass");
        MenuListTag parent = this.getParentMenu();
        if (parent == null) {
            return;
        }
        if (this.currentId == null) {
            this.currentId = parent.getCurrentId();
        }
        if (this.currentClass == null) {
            this.currentClass = parent.getCurrentClass();
        }
        if (this.disabledClass == null) {
            this.disabledClass = parent.getDisabledClass();
        }
        if (this.expandedClass == null) {
            this.expandedClass = parent.getExpandedClass();
        }
        if (this.defaultItemClass == null) {
            this.defaultItemClass = parent.defaultItemClass;
        }
        this.level = parent.level + 1;
    }

    protected MenuListTag getParentMenu() {
        MenuListTag parent = this;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof MenuListTag)) continue;
            return parent;
        }
        return null;
    }

    public String getCurrentId() {
        return this.currentId;
    }

    public String getCurrentClass() {
        return this.currentClass;
    }

    public String getDisabledClass() {
        return this.disabledClass;
    }

    public String getExpandedClass() {
        return this.expandedClass;
    }

    public int getLevel() {
        return this.level;
    }

    public String getItemStyleClass() {
        if (this.defaultItemClass != null && this.defaultItemClass.indexOf("{}") >= 0) {
            return StringUtils.replace((String)this.defaultItemClass, (String)"{}", (String)String.valueOf(this.level));
        }
        return this.defaultItemClass;
    }

    public void setCurrentId(String currentId) {
        this.currentId = currentId;
    }

    public void setCurrentClass(String currentClass) {
        this.currentClass = currentClass;
    }

    public void setDisabledClass(String disabledClass) {
        this.disabledClass = disabledClass;
    }

    public void setExpandedClass(String expandedClass) {
        this.expandedClass = expandedClass;
    }
}

