/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.event.PostConstructApplicationEvent;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemExistsException;
import org.apache.empire.jsf2.app.AppStartupListener;
import org.apache.empire.jsf2.app.FacesApplication;
import org.apache.empire.jsf2.app.FacesImplementation;
import org.apache.empire.jsf2.app.impl.MojarraImplementation;
import org.apache.empire.jsf2.app.impl.MyFacesImplementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FacesApplicationFactory
extends ApplicationFactory {
    private static final Logger log = LoggerFactory.getLogger(FacesApplicationFactory.class);
    private final Class<? extends FacesApplication> applicationClass;
    private final FacesImplementation facesImplementation;
    private final AppStartupListener startupListener;
    private volatile FacesApplication application;

    private static FacesImplementation detectFacesImplementation() {
        try {
            Class.forName("com.sun.faces.application.ApplicationFactoryImpl");
            return new MojarraImplementation();
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("org.apache.myfaces.application.ApplicationFactoryImpl");
                return new MyFacesImplementation();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected FacesApplicationFactory(Class<? extends FacesApplication> applicationClass, FacesImplementation facesImplementation, AppStartupListener startupListener) {
        if (facesImplementation == null) {
            facesImplementation = FacesApplicationFactory.detectFacesImplementation();
        }
        this.facesImplementation = facesImplementation;
        this.applicationClass = applicationClass;
        this.startupListener = startupListener;
        log.info("FacesApplicationFactory created for {0} using Implemenation {1}.", applicationClass, (Object)facesImplementation.getClass().getName());
    }

    protected FacesApplicationFactory(Class<? extends FacesApplication> applicationClass) {
        this(applicationClass, null, new AppStartupListener());
    }

    public Application getApplication() {
        if (this.application == null) {
            try {
                this.application = this.applicationClass.newInstance();
                this.facesImplementation.initApplication(this.application);
                this.application.subscribeToEvent(PostConstructApplicationEvent.class, this.startupListener);
            }
            catch (InstantiationException e) {
                throw new InternalException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new InternalException((Throwable)e);
            }
            log.info("Fin2Application Application instance created");
        }
        return this.application;
    }

    public void setApplication(Application application) {
        if (this.application != null) {
            throw new ItemExistsException((Object)this.application);
        }
        if (!(application instanceof FacesApplication)) {
            throw new InvalidArgumentException("application", (Object)application);
        }
        this.application = (FacesApplication)application;
    }
}

