/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pageelements;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.event.ValueChangeEvent;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBReader;
import org.apache.empire.db.DBRecordData;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.order.DBOrderByExpr;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.MiscellaneousErrorException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.pageelements.ListPageElement;
import org.apache.empire.jsf2.pages.Page;
import org.apache.empire.jsf2.utils.ListColumnFinder;
import org.apache.empire.jsf2.utils.ListItemSelection;
import org.apache.empire.jsf2.utils.ParameterMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanListPageElement<T>
extends ListPageElement<T>
implements ListItemSelection {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(BeanListPageElement.class);
    public static final String IDPARAM_PROPERTY = "idParam";
    public static final String NO_RESULT_ATTRIBUTE = "noQueryResult";
    private ListPageElement.ListTableInfo listTableInfo = null;
    protected DBRowSet rowset;
    protected Column defaultSortColumn;
    protected boolean defaultSortAscending = true;
    protected DBOrderByExpr secondarySortOrder = null;

    public BeanListPageElement(Page page, Class<T> beanClass, DBColumn defaultSortColumn, String propertyName) {
        super(page, beanClass, propertyName);
        if (defaultSortColumn == null) {
            throw new InvalidArgumentException("defaultSortColumn", (Object)defaultSortColumn);
        }
        this.rowset = defaultSortColumn.getRowSet();
        this.defaultSortColumn = defaultSortColumn;
        if (defaultSortColumn.getDataType() == DataType.DATE || defaultSortColumn.getDataType() == DataType.DATETIME) {
            this.defaultSortAscending = false;
        }
    }

    @Override
    protected void onInitPage() {
        ListPageElement.ListTableInfo lti = this.getTableInfo();
        if (lti.isValid() && this.items == null) {
            this.loadItems(true);
        }
    }

    @Override
    protected void onRefreshPage() {
        ListPageElement.ListTableInfo lti = this.getTableInfo();
        if (lti.isValid() && lti.isModified()) {
            this.loadItems(false);
        } else if (lti.isAllowPagination()) {
            this.updateScrollbar();
        }
    }

    @Override
    public int getItemCount() {
        return this.getTableInfo().getItemCount();
    }

    public Column getDefaultSortColumn() {
        return this.defaultSortColumn;
    }

    public boolean isDefaultSortAscending() {
        return this.defaultSortAscending;
    }

    public void setDefaultSortAscending(boolean defaultSortAscending) {
        this.defaultSortAscending = defaultSortAscending;
    }

    public DBOrderByExpr getSecondarySortOrder() {
        return this.secondarySortOrder;
    }

    public void setSecondarySortOrder(DBOrderByExpr secondarySortOrder) {
        this.secondarySortOrder = secondarySortOrder;
    }

    @Override
    public ListPageElement.ListTableInfo getTableInfo() {
        if (this.listTableInfo == null && (this.listTableInfo = this.getSessionObject(ListPageElement.ListTableInfo.class)) == null) {
            this.listTableInfo = new BeanListTableInfo();
            this.listTableInfo.setSortColumnName(this.defaultSortColumn.getName());
            this.listTableInfo.setSortAscending(this.defaultSortAscending);
            this.setSessionObject(ListPageElement.ListTableInfo.class, this.listTableInfo);
        }
        return this.listTableInfo;
    }

    @Override
    public void clearItems() {
        super.clearItems();
        this.setSessionObject(ListPageElement.ListTableInfo.class, null);
        this.listTableInfo = null;
        this.getParameterMap().clear(this.rowset);
    }

    protected ParameterMap getParameterMap() {
        return FacesUtils.getParameterMap(FacesUtils.getContext());
    }

    public void initItems(DBCommand queryCmd, DBCommand countCmd, int pageSize) {
        int count;
        this.clearItems();
        BeanListTableInfo lti = (BeanListTableInfo)this.getTableInfo();
        lti.setQueryCmd(queryCmd);
        if (pageSize > 0) {
            countCmd.clearSelect();
            countCmd.select(this.rowset.count());
            count = this.rowset.getDatabase().querySingleInt(countCmd.getSelect(), countCmd.getParamValues(), 0, this.getConnection((DBObject)this.rowset));
            lti.init(count, pageSize);
        } else {
            lti.init(-1, 0);
        }
        lti.setSortOrderChanged(true);
        this.loadItems(true);
        count = this.getTableInfo().getItemCount();
        if (count == 0) {
            FacesUtils.setRequestAttribute(FacesUtils.getContext(), NO_RESULT_ATTRIBUTE, true);
        }
        log.info("ItemList initialized for {} item count is {}.", (Object)this.getPropertyName(), (Object)count);
    }

    public final void initItems(DBCommand queryCmd, int pageSize) {
        DBCommand countCmd = queryCmd.clone();
        this.initItems(queryCmd, countCmd, 0);
    }

    public final void initItems(DBCommand queryCmd) {
        this.initItems(queryCmd, 0);
    }

    public boolean isResultEmpty() {
        Object noQueryResult = FacesUtils.getRequestAttribute(FacesUtils.getContext(), NO_RESULT_ATTRIBUTE);
        return noQueryResult != null ? ObjectUtils.getBoolean((Object)noQueryResult) : false;
    }

    private void loadItems(boolean initScrollbar) {
        BeanListTableInfo lti = (BeanListTableInfo)this.getTableInfo();
        DBReader r = new DBReader();
        try {
            DBCommand queryCmd = lti.getQueryCmd();
            if (queryCmd == null) {
                throw new ObjectNotValidException((Object)this);
            }
            boolean loadPageFromPosition = lti.isValid() && lti.isAllowPagination();
            lti.setValid(false);
            if (lti.isSortOrderChanged()) {
                this.setOrderBy(queryCmd);
                lti.setSortOrderChanged(false);
            }
            r.open((DBCommandExpr)queryCmd, this.getConnection((DBObject)queryCmd));
            int position = 0;
            int maxItems = 1000;
            if (loadPageFromPosition) {
                position = lti.getPosition();
                if (position < 0) {
                    position = 0;
                }
                if (position > lti.getItemCount() - lti.getPageSize()) {
                    position = lti.getItemCount() - lti.getPageSize();
                }
                if (position > 0) {
                    r.skipRows(position);
                } else {
                    position = 0;
                }
                maxItems = lti.getPageSize();
            }
            this.items = r.getBeanList(this.beanClass, maxItems);
            if (this.items == null) {
                throw new UnexpectedReturnValueException((Object)this.items, "DBReader.getBeanList");
            }
            this.generateIdParams(this.rowset, this.items);
            this.assignSelectionMap(this.items);
            if (loadPageFromPosition) {
                if (position + this.items.size() > lti.getItemCount()) {
                    log.warn("Item count of {} has changed. Adjusting item count.", (Object)this.getPropertyName());
                    lti.init(position + this.items.size(), lti.getPageSize());
                }
                lti.setPosition(position);
                lti.setModified(false);
                lti.setValid(true);
            } else {
                lti.init(this.items.size(), 0);
            }
        }
        catch (RuntimeException e) {
            log.error("Error loading bean list " + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            r.close();
            if (lti.isAllowPagination()) {
                if (initScrollbar) {
                    this.initScrollbar();
                } else {
                    this.updateScrollbar();
                }
            }
        }
    }

    protected void setOrderBy(DBCommand cmd) {
        cmd.clearOrderBy();
        String sortColumnName = this.getTableInfo().getSortColumnName();
        boolean sortAscending = this.getTableInfo().getSortAscending();
        DBColumn sortColumn = this.rowset.getColumn(sortColumnName);
        if (sortColumn == null && this.getPage() instanceof ListColumnFinder) {
            sortColumn = ((ListColumnFinder)((Object)this.getPage())).findColumn(sortColumnName);
        }
        if (sortColumn == null) {
            log.error("Invalid Sort Column {}. Using Default!", (Object)sortColumnName);
            sortColumn = (DBColumn)this.getDefaultSortColumn();
            this.getTableInfo().setSortColumnName(sortColumn.getName());
        }
        this.setOrderBy(cmd, (DBColumnExpr)sortColumn, sortAscending);
    }

    protected void setOrderBy(DBCommand cmd, DBColumnExpr sortColumn, boolean sortAscending) {
        if (sortAscending) {
            cmd.orderBy(new DBColumnExpr[]{sortColumn});
        } else {
            cmd.orderBy(new DBOrderByExpr[]{sortColumn.desc()});
        }
        if (this.secondarySortOrder != null && !this.secondarySortOrder.getColumn().equals((Object)sortColumn)) {
            cmd.orderBy(new DBOrderByExpr[]{this.secondarySortOrder});
        }
    }

    public void initScrollbar() {
        ListPageElement.ListTableInfo lti = this.getTableInfo();
        int max = lti.getItemCount() - lti.getPageSize();
        if (max < 0) {
            max = 0;
        }
        int pos = max;
        if (max > lti.getPosition()) {
            pos = max - lti.getPosition();
        }
        StringBuilder b = new StringBuilder();
        b.append("initScrollbar('");
        b.append(String.valueOf(this.getPropertyName()));
        b.append("',");
        b.append(String.valueOf(max));
        b.append(",");
        b.append(String.valueOf(pos));
        b.append(",");
        b.append(String.valueOf(lti.getPageSize()));
        b.append(");");
        this.getPage().addJavascriptCall(b.toString());
    }

    public void updateScrollbar() {
        int pos = this.getScrollbarPosition();
        StringBuilder b = new StringBuilder();
        b.append("updateScrollbar('");
        b.append(String.valueOf(this.getPropertyName()));
        b.append("',");
        b.append(String.valueOf(pos));
        b.append(");");
        this.getPage().addJavascriptCall(b.toString());
    }

    public int getScrollbarPosition() {
        ListPageElement.ListTableInfo lti = this.getTableInfo();
        if (!lti.isValid()) {
            return 0;
        }
        if (lti.getItemCount() <= lti.getPageSize()) {
            return 0;
        }
        int pos = lti.getItemCount() - lti.getPageSize() - lti.getPosition();
        return pos >= 0 ? pos : 0;
    }

    public void setScrollbarPosition(int value) {
    }

    public void positionValueChanged(ValueChangeEvent ve) {
        ListPageElement.ListTableInfo lti = this.getTableInfo();
        int val = ObjectUtils.getInteger((Object)ve.getNewValue());
        int pos = lti.getItemCount() - lti.getPageSize() - val;
        lti.setPosition(pos > 0 ? pos : 0);
    }

    public Set<Object[]> getSelectedItemKeys() {
        if (this.selectedItems == null) {
            return null;
        }
        HashSet<Object[]> items = new HashSet<Object[]>(this.selectedItems.size());
        for (String idParam : this.selectedItems) {
            Object[] key = this.getParameterMap().get(this.rowset, idParam);
            if (key == null) {
                log.warn("Object does not exist in ParameterMap!");
                continue;
            }
            items.add(key);
        }
        return items;
    }

    public void setSelectedItems(Set<Object[]> items) {
        if (this.selectedItems == null) {
            throw new NotSupportedException((Object)this, "setSelectedItems");
        }
        this.selectedItems = new ListPageElement.SelectionSet(items.size());
        for (Object[] key : items) {
            if (key == null || key.length == 0) {
                log.warn("Cannot select Null-Object.");
                continue;
            }
            String idParam = this.getParameterMap().put(this.rowset, key);
            this.selectedItems.add(idParam);
        }
    }

    protected void generateIdParams(DBRowSet rowset, List<?> items) {
        DBColumn[] keyCols = rowset.getKeyColumns();
        if (keyCols == null) {
            throw new NoPrimaryKeyException(rowset);
        }
        for (Object item : items) {
            Object[] key = this.getItemKey(keyCols, item);
            String idparam = this.getParameterMap().put(rowset, key);
            try {
                BeanUtils.setProperty(item, (String)IDPARAM_PROPERTY, (Object)idparam);
            }
            catch (Exception e) {
                log.error("Error setting property idparam on bean.", (Throwable)e);
                throw new InternalException((Throwable)e);
            }
        }
    }

    protected Object[] getItemKey(DBColumn[] cols, Object item) {
        Object[] key = new Object[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            if (item instanceof DBRecordData) {
                key[i] = ((DBRecordData)item).getValue((ColumnExpr)cols[i]);
                continue;
            }
            String propName = cols[i].getBeanPropertyName();
            if (propName == null || propName.length() == 0) {
                throw new MiscellaneousErrorException("Invalid Bean Property Name");
            }
            try {
                key[i] = BeanUtils.getSimpleProperty((Object)item, (String)propName);
                continue;
            }
            catch (Exception e) {
                String msg = "Error getting property '" + propName + "' from bean.";
                log.error(msg, (Throwable)e);
                throw new InternalException((Throwable)e);
            }
        }
        return key;
    }

    @Override
    public DBCommand getItemQueryCmd() {
        BeanListTableInfo lti = (BeanListTableInfo)this.getTableInfo();
        DBCommand cmd = lti.getQueryCmd().clone();
        Set<Object[]> items = this.getSelectedItemKeys();
        if (items.size() > 0) {
            DBColumn[] pk = this.rowset.getKeyColumns();
            DBColumn keyExpr = pk[0];
            for (int i = 1; i < pk.length; ++i) {
                keyExpr = keyExpr.append((Object)pk[i]);
            }
            String[] keys = new String[items.size()];
            int i = 0;
            for (Object[] item : items) {
                keys[i++] = StringUtils.arrayToString((Object[])item, (String)"");
            }
            if (this.isInvertSelection()) {
                cmd.where((DBCompareExpr)keyExpr.notIn((Object)keys));
            } else {
                cmd.where((DBCompareExpr)keyExpr.in((Object)keys));
            }
        }
        cmd.clearSelect();
        cmd.clearGroupBy();
        return cmd;
    }

    public static class BeanListTableInfo
    extends ListPageElement.ListTableInfo {
        private static final long serialVersionUID = 1L;
        private DBCommand queryCmd = null;

        public DBCommand getQueryCmd() {
            return this.queryCmd;
        }

        public void setQueryCmd(DBCommand queryCmd) {
            this.queryCmd = queryCmd;
        }
    }
}

