/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.app.TextResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InputControl {
    private static final Logger log = LoggerFactory.getLogger(InputControl.class);
    public static final String NUMBER_TYPE_ATTRIBUTE = "numberType";
    public static final String NUMBER_GROUPSEP_ATTRIBUTE = "numberGroupSeparator";
    public static final String NUMBER_FRACTION_DIGITS = "numberFractionDigits";
    public static final String MINVALUE_ATTRIBUTE = "minValue";
    public static final String MAXVALUE_ATTRIBUTE = "maxValue";
    public static final String CURRENCY_CODE_ATTRIBUTE = "currencyCode";
    public static final String FORMAT_NULL = "null:";
    public static final String FORMAT_NULL_ATTRIBUTE = "format:null";
    private String name;

    public InputControl() {
        log.info("InputControl of class {} created.", (Object)this.getClass().getName());
    }

    protected InputControl(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public String getLabelForId(InputInfo ii) {
        return ii.getInputId();
    }

    public void renderValue(ValueInfo vi, ResponseWriter writer) throws IOException {
        String text = this.formatValue(vi);
        writer.append((CharSequence)(StringUtils.isEmpty((String)text) ? "&nbsp;" : text));
    }

    public void renderInput(UIComponent comp, InputInfo ii, FacesContext context, boolean encode) throws IOException {
        this.createInputComponents(comp, ii, context, comp.getChildren());
        if (!encode) {
            return;
        }
        for (UIComponent child : comp.getChildren()) {
            child.encodeAll(context);
        }
    }

    public void postUpdateModel(UIComponent comp, InputInfo ii, FacesContext fc) {
        UIInput input = this.getInputComponent(comp);
        if (input == null) {
            return;
        }
        this.clearSubmittedValue(input);
    }

    public Object getInputValue(UIComponent comp, InputInfo ii, boolean submitted) {
        Object value;
        UIInput input = this.getInputComponent(comp);
        if (input == null) {
            throw new ObjectNotValidException((Object)this);
        }
        Object object = value = submitted ? input.getSubmittedValue() : input.getValue();
        if (submitted) {
            if (value != null) {
                String clientId;
                if (ii.isDisabled()) {
                    log.debug("Ignoring submitted value for disabled field {}.", (Object)ii.getColumn().getName());
                    input.setSubmittedValue(null);
                    return null;
                }
                FacesContext fc = FacesContext.getCurrentInstance();
                Map reqMap = fc.getExternalContext().getRequestMap();
                if (reqMap.containsKey(clientId = input.getClientId())) {
                    log.warn("OOps, what is going on here?");
                }
                reqMap.put(clientId, value);
            }
            if (value instanceof String && ((String)value).length() > 0) {
                return this.parseInputValue((String)value, ii);
            }
        }
        return value;
    }

    protected void setInputValue(UIInput input, InputInfo ii) {
        Object value;
        String clientId;
        FacesContext fc = FacesContext.getCurrentInstance();
        Map reqMap = fc.getExternalContext().getRequestMap();
        if (reqMap.containsKey(clientId = input.getClientId())) {
            Object value2 = reqMap.get(clientId);
            input.setSubmittedValue(value2);
            return;
        }
        if (input.getSubmittedValue() != null) {
            if (log.isDebugEnabled()) {
                log.debug("clearing submitted value for {}. value is {}.", (Object)ii.getColumn().getName(), input.getSubmittedValue());
            }
            input.setSubmittedValue(null);
        }
        if ((value = ii.getValue(false)) instanceof ValueExpression) {
            input.setValue(null);
            input.setLocalValueSet(false);
            input.setValueExpression("value", (ValueExpression)value);
        } else {
            value = this.formatInputValue(value, ii);
            input.setValue(value);
        }
    }

    protected void clearSubmittedValue(UIInput input) {
        input.setSubmittedValue(null);
        FacesContext fc = FacesContext.getCurrentInstance();
        Map reqMap = fc.getExternalContext().getRequestMap();
        String clientId = input.getClientId();
        if (reqMap.containsKey(clientId)) {
            reqMap.remove(clientId);
        }
    }

    protected Object formatInputValue(Object value, InputInfo ii) {
        return value;
    }

    protected Object parseInputValue(String value, InputInfo ii) {
        return value;
    }

    protected abstract void createInputComponents(UIComponent var1, InputInfo var2, FacesContext var3, List<UIComponent> var4);

    protected UIInput getInputComponent(UIComponent parent) {
        int count = parent.getChildCount();
        if (count != 1) {
            return null;
        }
        UIComponent inp = (UIComponent)parent.getChildren().get(0);
        if (!(inp instanceof UIInput)) {
            throw new UnexpectedReturnValueException((Object)inp, "comp.getChildren().get(0)");
        }
        return (UIInput)inp;
    }

    protected void copyAttributes(UIComponent parent, InputInfo ii, UIInput input, String additonalStyle) {
        String inputId = ii.getInputId();
        if (StringUtils.isNotEmpty((String)inputId)) {
            input.getAttributes().put("id", inputId);
        }
        String styleClass = ii.getStyleClass(additonalStyle);
        input.getAttributes().put("styleClass", styleClass);
        this.copyAttribute(ii, input, "style");
        this.copyAttribute(ii, input, "tabindex");
        this.copyAttribute(ii, input, "onchange");
        this.copyAttribute(ii, input, "onfocus");
        this.copyAttribute(ii, input, "onblur");
        this.copyAttribute(ii, input, "onkeydown");
        this.copyAttribute(ii, input, "onkeyup");
        this.copyAttribute(ii, input, "onclick");
        Object immediate = ii.getAttribute("immediate");
        if (immediate != null && ObjectUtils.getBoolean((Object)immediate)) {
            log.warn("Immediate attribute is not yet supported for {}!", (Object)ii.getColumn().getName());
        }
    }

    protected final void copyAttributes(UIComponent parent, InputInfo ii, UIInput input) {
        this.copyAttributes(parent, ii, input, null);
    }

    protected void copyAttribute(InputInfo ii, UIInput input, String name) {
        if (ii == null) {
            throw new InvalidArgumentException("InputInfo", (Object)ii);
        }
        Object value = ii.getAttribute(name);
        if (value != null) {
            input.getAttributes().put(name, value);
        }
    }

    public void addRemoveDisabledStyle(UIInput input, boolean disabled) {
        this.addRemoveStyle(input, " eInpDis", disabled);
    }

    public void addRemoveInvalidStyle(UIInput input, boolean invalid) {
        this.addRemoveStyle(input, " eInvalid", invalid);
    }

    public void addRemoveStyle(UIInput input, String styleName, boolean setStyle) {
        boolean hasStyle;
        String styleClass = StringUtils.toString(input.getAttributes().get("styleClass"), (String)"");
        boolean bl = hasStyle = styleClass.indexOf(styleName) >= 0;
        if (setStyle == hasStyle) {
            return;
        }
        if (styleClass.endsWith("-dis")) {
            styleClass = styleClass.substring(0, styleClass.length() - 4);
        }
        styleClass = setStyle ? styleClass + styleName : styleClass.replace(styleName, "");
        input.getAttributes().put("styleClass", styleClass);
    }

    protected String formatValue(Object value, ValueInfo vi) {
        Options options = vi.getOptions();
        if (options != null && !options.isEmpty() && !this.hasFormatOption(vi, "nolookup")) {
            String text = options.get(value);
            if (text != null) {
                return vi.getText(text);
            }
            log.error("The element '" + String.valueOf(value) + "' is not part of the supplied option list.");
        }
        if (value == null) {
            value = this.getFormatOption(vi, FORMAT_NULL, FORMAT_NULL_ATTRIBUTE);
        }
        String s = StringUtils.toString((Object)value, (String)"");
        if (this.hasFormatOption(vi, "noencode")) {
            return s;
        }
        return this.escapeHTML(s);
    }

    protected final String formatValue(ValueInfo vi) {
        return this.formatValue(vi.getValue(true), vi);
    }

    protected String escapeHTML(String text) {
        return text;
    }

    protected boolean hasFormatOption(ValueInfo vi, String option) {
        String format = vi.getFormat();
        return format != null ? format.indexOf(option) >= 0 : false;
    }

    private String getFormatOption(ValueInfo vi, String option) {
        String format = vi.getFormat();
        if (format == null) {
            return null;
        }
        int beg = format.indexOf(option);
        if (beg < 0) {
            return null;
        }
        int end = format.indexOf(59, (beg += option.length()) + 1);
        if (end < beg) {
            return format.substring(beg);
        }
        return format.substring(beg, end);
    }

    protected Object getFormatOption(ValueInfo vi, String option, String columnAttributeName) {
        String format = this.getFormatOption(vi, option);
        return format != null ? format : vi.getColumn().getAttribute(columnAttributeName);
    }

    protected String getFormatString(ValueInfo vi, String option, String columnAttributeName) {
        return StringUtils.toString((Object)this.getFormatOption(vi, option, columnAttributeName));
    }

    protected int getFormatInteger(ValueInfo vi, String option, String columnAttributeName) {
        return ObjectUtils.getInteger((Object)this.getFormatOption(vi, option, columnAttributeName));
    }

    public static interface InputInfo
    extends ValueInfo {
        public void setValue(Object var1);

        public void validate(Object var1);

        public boolean isRequired();

        public boolean isDisabled();

        public boolean isFieldReadOnly();

        public String getInputId();

        public String getStyleClass(String var1);

        public boolean hasError();

        public Object getAttribute(String var1);

        public Object getAttributeEx(String var1);
    }

    public static interface ValueInfo {
        public Column getColumn();

        public Options getOptions();

        public Object getValue(boolean var1);

        public String getFormat();

        public Locale getLocale();

        public String getText(String var1);

        public TextResolver getTextResolver();
    }
}

