/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueTag
extends UIOutput {
    private static final Logger log = LoggerFactory.getLogger(ValueTag.class);
    private TagEncodingHelper helper = new TagEncodingHelper(this, "eVal");

    public ValueTag() {
        log.trace("component value created");
    }

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.helper.encodeBegin();
        InputControl control = this.helper.getInputControl();
        InputControl.ValueInfo vi = this.helper.getValueInfo(context);
        ResponseWriter writer = context.getResponseWriter();
        String tag = this.writeStartElement(vi, writer);
        control.renderValue(vi, writer);
        if (tag != null) {
            writer.endElement(tag);
        }
    }

    protected String writeStartElement(InputControl.ValueInfo vi, ResponseWriter writer) throws IOException {
        Map map = this.getAttributes();
        String tag = StringUtils.toString(map.get("tag"));
        String title = StringUtils.toString(map.get("title"));
        if (tag == null && title == null && !map.containsKey("styleClass")) {
            return null;
        }
        if (StringUtils.isEmpty((String)tag)) {
            tag = "span";
        }
        writer.startElement(tag, (UIComponent)this);
        String addlStyle = null;
        DataType dataType = vi.getColumn().getDataType();
        if (dataType.isNumeric()) {
            try {
                Object val = this.helper.getDataValue(true);
                if (val != null && ObjectUtils.getInteger((Object)val) < 0) {
                    addlStyle = "eValNeg";
                }
            }
            catch (Exception e) {
                log.warn("Unable to detect sign of numeric value {}. Message is {}!", (Object)vi.getColumn().getName(), (Object)e.getMessage());
            }
        }
        this.helper.writeAttribute(writer, "class", this.helper.getTagStyleClass(dataType, addlStyle));
        this.helper.writeAttribute(writer, "style", map.get("style"));
        this.helper.writeAttribute(writer, "title", this.helper.getValueTooltip(title));
        return tag;
    }
}

