/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.jsf2.app.FacesApplication;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.pages.Page;
import org.apache.empire.jsf2.pages.PageDefinition;
import org.apache.empire.jsf2.pages.PageOutcome;
import org.apache.empire.jsf2.utils.ParameterMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacesUtils {
    private static final Logger log = LoggerFactory.getLogger(FacesUtils.class);
    public static final String SKIP_INPUT_VALIDATION_PARAM = "empire.jsf.input.skipValidation";
    public static final String PARAMETER_MAP_ATTRIBUTE = ParameterMap.class.getSimpleName();
    public static final String PAGE_RESOURCE_MAP_ATTRIBUTE = "pageResources";

    public static FacesApplication getFacesApplication() {
        ApplicationFactory appFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        Application app = appFactory.getApplication();
        return (FacesApplication)app;
    }

    public static FacesContext getContext() {
        return FacesContext.getCurrentInstance();
    }

    public static Map<String, Object> getSessionMap(FacesContext fc) {
        return fc.getExternalContext().getSessionMap();
    }

    public static Map<String, Object> getRequestMap(FacesContext fc) {
        return fc.getExternalContext().getRequestMap();
    }

    public static HttpServletRequest getHttpRequest(FacesContext fc) {
        return (HttpServletRequest)fc.getExternalContext().getRequest();
    }

    public static Object getRequestAttribute(FacesContext fc, String key) {
        return FacesUtils.getHttpRequest(fc).getAttribute(key);
    }

    public static void setRequestAttribute(FacesContext fc, String key, Object value) {
        if (value != null) {
            FacesUtils.getHttpRequest(fc).setAttribute(key, value);
        } else {
            FacesUtils.getHttpRequest(fc).removeAttribute(key);
        }
    }

    public static String getRequestParam(FacesContext context, String param) {
        return (String)context.getExternalContext().getRequestParameterMap().get(param);
    }

    public static void redirectDirectly(FacesContext fc, String url) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Redirecting directly to {}.", (Object)url);
            }
            fc.getExternalContext().redirect(url);
            fc.responseComplete();
        }
        catch (IOException e) {
            log.error("Unable to redirect to " + url);
        }
    }

    public static void redirectDirectly(FacesContext fc, PageOutcome outcome) {
        String ctxPath = fc.getExternalContext().getRequestContextPath();
        String pageURI = ctxPath + outcome.toString();
        FacesUtils.redirectDirectly(fc, pageURI);
    }

    public static void redirectDirectly(FacesContext fc, PageDefinition page) {
        FacesUtils.redirectDirectly(fc, page.getOutcome());
    }

    public Connection getConnection(FacesContext fc, DBDatabase db) {
        return FacesUtils.getFacesApplication().getConnectionForRequest(fc, db);
    }

    public void releaseAllConnections(FacesContext fc, boolean commit) {
        FacesUtils.getFacesApplication().releaseAllConnections(fc, commit);
    }

    public void releaseAllConnections(FacesContext fc, DBDatabase db, boolean commit) {
        FacesUtils.getFacesApplication().releaseConnection(fc, db, commit);
    }

    public static Page getPage(FacesContext fc) {
        Page page = (Page)FacesUtils.getManagedBean(fc, "page");
        if (page == null) {
            log.error("Page bean {} does not exist!");
        }
        return page;
    }

    public static ParameterMap getParameterMap(FacesContext fc) {
        Map sm = fc.getExternalContext().getSessionMap();
        Object pm = sm.get(PARAMETER_MAP_ATTRIBUTE);
        if (pm == null) {
            pm = new ParameterMap();
            sm.put(PARAMETER_MAP_ATTRIBUTE, pm);
        }
        return (ParameterMap)pm;
    }

    public static Map<String, Object> getPageResourceMap(FacesContext fc) {
        Map sm = fc.getExternalContext().getSessionMap();
        HashMap rm = (HashMap)sm.get(PAGE_RESOURCE_MAP_ATTRIBUTE);
        if (rm == null) {
            rm = new HashMap();
            sm.put(PAGE_RESOURCE_MAP_ATTRIBUTE, rm);
        }
        return rm;
    }

    public static Object getManagedBean(FacesContext fc, String name) {
        if (fc == null) {
            throw new NullPointerException("context must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        ELContext elcontext = fc.getELContext();
        Application application = fc.getApplication();
        return application.getELResolver().getValue(elcontext, null, (Object)name);
    }

    public static <T> T getManagedBean(FacesContext fc, Class<T> cls) {
        String name = cls.getName();
        int i = name.lastIndexOf(46) + 1;
        Object bean = FacesUtils.getManagedBean(fc, name = name.substring(i, i + 1).toLowerCase() + name.substring(i + 1));
        if (bean == null) {
            log.warn("Managed Bean {} ist not available.", (Object)name);
        }
        return (T)bean;
    }

    public static String getRealPath(FacesContext fc, String path) {
        return ((ServletContext)fc.getExternalContext().getContext()).getRealPath(path);
    }

    public static String getFilePath(FacesContext fc, String path, String file) {
        String realPath = FacesUtils.getRealPath(fc, path);
        return realPath.endsWith(File.separator) ? realPath + file : realPath + File.separator + file;
    }

    public static TextResolver getTextResolver(FacesContext fc) {
        return ((FacesApplication)fc.getApplication()).getTextResolver(fc);
    }

    public static String getMessage(FacesContext fc, String key) {
        return FacesUtils.getTextResolver(fc).resolveKey(key);
    }

    public static void addInfoMessage(FacesContext fc, String clientId, String msg) {
        fc.addMessage(clientId, new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg));
    }

    public static void addInfoMessage(FacesContext fc, String msg) {
        FacesUtils.addInfoMessage(fc, null, msg);
    }

    public static void addErrorMessage(FacesContext fc, String clientId, String msg) {
        fc.addMessage(clientId, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
    }

    public static void addErrorMessage(FacesContext fc, String msg) {
        FacesUtils.addErrorMessage(fc, null, msg);
    }

    public static boolean isSkipInputValidation(FacesContext fc) {
        String val = FacesUtils.getRequestParam(fc, SKIP_INPUT_VALIDATION_PARAM);
        return val != null && ObjectUtils.getBoolean((Object)val);
    }
}

