/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import com.sun.faces.application.ApplicationImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PostConstructApplicationEvent;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.jsf2.app.AppStartupListener;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.app.TextResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FacesApplication
extends ApplicationImpl {
    private static final Logger log = LoggerFactory.getLogger(FacesApplication.class);
    private static final String CONNECTION_ATTRIBUTE = "dbConnections";
    public static String APPLICATION_ATTRIBUTE = "app";
    protected TextResolver[] textResolvers = null;
    private String webRoot = null;

    protected FacesApplication(AppStartupListener startupListener) {
        this.subscribeToEvent(PostConstructApplicationEvent.class, startupListener);
    }

    protected FacesApplication() {
        this(new AppStartupListener());
    }

    protected abstract DataSource getAppDataSource(DBDatabase var1);

    protected abstract void init(ServletContext var1);

    protected void initComplete(ServletContext servletContext) {
        this.webRoot = servletContext.getContextPath();
        if (this.textResolvers == null) {
            this.initTextResolvers();
        }
        log.info("FacesApplication initialization complete");
    }

    public void onChangeView(FacesContext fc, String viewId) {
        Map<String, Object> sm = FacesUtils.getSessionMap(fc);
        if (sm != null) {
            sm.remove("pageResources");
        }
    }

    public void addJavascriptCall(FacesContext fc, String function) {
        throw new NotSupportedException((Object)this, "addJavascriptCall");
    }

    public String getWebRoot() {
        return this.webRoot;
    }

    public Locale getContextLocale(FacesContext ctx) {
        Locale defaultLocale;
        Locale locale = defaultLocale = Locale.getDefault();
        UIViewRoot root = ctx.getViewRoot();
        if (null != root && null == (locale = root.getLocale())) {
            locale = defaultLocale;
        }
        return locale;
    }

    public boolean hasError(FacesContext fc) {
        Iterator msgIterator = fc.getMessages();
        if (msgIterator != null) {
            while (msgIterator.hasNext()) {
                FacesMessage.Severity fms = ((FacesMessage)msgIterator.next()).getSeverity();
                if (fms != FacesMessage.SEVERITY_ERROR && fms != FacesMessage.SEVERITY_FATAL) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPartialSubmit(FacesContext fc) {
        return false;
    }

    public String getPartialSubmitComponentId(FacesContext fc) {
        return null;
    }

    public UIComponent findComponent(FacesContext fc, String componentId, UIComponent nearComponent) {
        if (StringUtils.isEmpty((String)componentId)) {
            throw new InvalidArgumentException("componentId", (Object)componentId);
        }
        UIComponent component = null;
        if (nearComponent != null && (component = nearComponent.findComponent(componentId)) == null) {
            UIComponent nextParent = nearComponent;
            do {
                for (nextParent = nextParent.getParent(); nextParent != null && !(nextParent instanceof NamingContainer); nextParent = nextParent.getParent()) {
                }
            } while (nextParent != null && (component = nextParent.findComponent(componentId)) == null);
        }
        if (component == null) {
            component = FacesApplication.findChildComponent((UIComponent)fc.getViewRoot(), componentId);
        }
        return component;
    }

    public static UIComponent findChildComponent(UIComponent parent, String componentId) {
        UIComponent component = null;
        if (parent.getChildCount() == 0) {
            return null;
        }
        for (UIComponent nextChild : parent.getChildren()) {
            if (nextChild instanceof NamingContainer) {
                component = nextChild.findComponent(componentId);
            }
            if (component == null) {
                FacesApplication.findChildComponent(nextChild, componentId);
            }
            if (component == null) continue;
            break;
        }
        return component;
    }

    public String getDefaultControlType(DataType dataType) {
        switch (dataType) {
            case CLOB: {
                return "textarea";
            }
        }
        return "text";
    }

    protected void initTextResolvers() {
        int count = 0;
        Iterator locales = this.getSupportedLocales();
        count = 0;
        while (locales.hasNext()) {
            locales.next();
            ++count;
        }
        String messageBundle = this.getMessageBundle();
        this.textResolvers = new TextResolver[count];
        locales = this.getSupportedLocales();
        int i = 0;
        while (locales.hasNext()) {
            Locale locale = (Locale)locales.next();
            this.textResolvers[i] = new TextResolver(ResourceBundle.getBundle(messageBundle, locale));
            ++i;
        }
    }

    public TextResolver getTextResolver(Locale locale) {
        if (this.textResolvers == null || this.textResolvers.length == 0) {
            throw new NotSupportedException((Object)this, "getTextResolver");
        }
        for (int i = 0; i < this.textResolvers.length; ++i) {
            if (!locale.equals(this.textResolvers[i].getLocale())) continue;
            return this.textResolvers[i];
        }
        return this.textResolvers[0];
    }

    public TextResolver getTextResolver(FacesContext ctx) {
        return this.getTextResolver(this.getContextLocale(ctx));
    }

    public ResourceBundle getResourceBundle(FacesContext fc, String var) {
        if (var.equals("msg")) {
            TextResolver resolver = this.getTextResolver(fc);
            return resolver.getResourceBundle();
        }
        return null;
    }

    protected Connection getConnection(DBDatabase db) {
        try {
            Connection conn = this.getAppDataSource(db).getConnection();
            conn.setAutoCommit(false);
            return conn;
        }
        catch (SQLException e) {
            log.error("Failed to get connection from pool.", (Throwable)e);
            throw new InternalException((Throwable)e);
        }
    }

    protected void releaseConnection(DBDatabase db, Connection conn, boolean commit) {
        try {
            if (conn == null) {
                return;
            }
            if (commit) {
                db.commit(conn);
                log.debug("REQUEST {}: commited.");
            } else {
                db.rollback(conn);
                log.debug("REQUEST {}: rolled back.");
            }
            conn.close();
            if (log.isDebugEnabled()) {
                log.debug("REQUEST {}: returned connection to pool.");
            }
        }
        catch (SQLException e) {
            log.error("Error releasing connection", (Throwable)e);
            e.printStackTrace();
        }
    }

    public Connection getConnectionForRequest(FacesContext fc, DBDatabase db) {
        if (fc == null) {
            throw new InvalidArgumentException("FacesContext", (Object)fc);
        }
        if (db == null) {
            throw new InvalidArgumentException("DBDatabase", (Object)db);
        }
        HashMap<DBDatabase, Connection> connMap = (HashMap<DBDatabase, Connection>)FacesUtils.getRequestAttribute(fc, CONNECTION_ATTRIBUTE);
        if (connMap != null && connMap.containsKey(db)) {
            return (Connection)connMap.get(db);
        }
        Connection conn = this.getConnection(db);
        if (conn == null) {
            return null;
        }
        if (connMap == null) {
            connMap = new HashMap<DBDatabase, Connection>();
            FacesUtils.setRequestAttribute(fc, CONNECTION_ATTRIBUTE, connMap);
        }
        connMap.put(db, conn);
        return conn;
    }

    public void releaseAllConnections(FacesContext fc, boolean commit) {
        Map connMap = (Map)FacesUtils.getRequestAttribute(fc, CONNECTION_ATTRIBUTE);
        if (connMap != null) {
            for (Map.Entry e : connMap.entrySet()) {
                this.releaseConnection((DBDatabase)e.getKey(), (Connection)e.getValue(), commit);
            }
            FacesUtils.setRequestAttribute(fc, CONNECTION_ATTRIBUTE, null);
        }
    }

    public void releaseAllConnections(FacesContext fc) {
        this.releaseAllConnections(fc, !this.hasError(fc));
    }

    public void releaseConnection(FacesContext fc, DBDatabase db, boolean commit) {
        Map connMap = (Map)FacesUtils.getRequestAttribute(fc, CONNECTION_ATTRIBUTE);
        if (connMap != null && connMap.containsKey(db)) {
            this.releaseConnection(db, (Connection)connMap.get(db), commit);
            connMap.remove(db);
            if (connMap.size() == 0) {
                FacesUtils.setRequestAttribute(fc, CONNECTION_ATTRIBUTE, null);
            }
        }
    }

    public void releaseConnection(FacesContext fc, DBDatabase db) {
        this.releaseConnection(fc, db, !this.hasError(fc));
    }
}

