/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.utils;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.DataType;
import org.apache.empire.data.Record;
import org.apache.empire.data.RecordData;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.exceptions.BeanPropertyGetException;
import org.apache.empire.exceptions.BeanPropertySetException;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.PropertyReadOnlyException;
import org.apache.empire.jsf2.app.FacesApplication;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.components.InputTag;
import org.apache.empire.jsf2.components.LinkTag;
import org.apache.empire.jsf2.components.RecordTag;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagEncodingHelper
implements NamingContainer {
    private static final Logger log = LoggerFactory.getLogger(TagEncodingHelper.class);
    public static final String COLATTR_ABBR_TITLE = "ABBR_TITLE";
    private final UIOutput tag;
    private final String tagCssStyle;
    private Column column = null;
    private Object record = null;
    private RecordTag recordTag = null;
    private Boolean hasValueExpr = null;
    private InputControl control = null;
    private TextResolver textResolver = null;
    private static final String CC_ATTR_EXPR = "#{cc.attrs.";
    public static final String CSS_DATA_TYPE_NONE = "";
    public static final String CSS_DATA_TYPE_IDENT = " eTypeIdent";
    public static final String CSS_DATA_TYPE_NUMBER = " eTypeNumber";
    public static final String CSS_DATA_TYPE_TEXT = " eTypeText";
    public static final String CSS_DATA_TYPE_LONGTEXT = " eTypeLongText";
    public static final String CSS_DATA_TYPE_DATE = " eTypeDate";
    public static final String CSS_DATA_TYPE_BOOL = " eTypeBool";

    public TagEncodingHelper(UIOutput tag, String tagCssStyle) {
        this.tag = tag;
        this.tagCssStyle = tagCssStyle;
    }

    public void encodeBegin() {
        if (this.record != null && !(this.record instanceof Record)) {
            this.record = null;
        }
    }

    public InputControl getInputControl() {
        if (this.control != null) {
            return this.control;
        }
        if (this.getColumn() == null) {
            throw new NotSupportedException((Object)this, "getInputControl");
        }
        String controlType = this.column.getControlType();
        InputControl control = null;
        if (StringUtils.isNotEmpty((String)controlType)) {
            control = InputControlManager.getControl(controlType);
        }
        if (control == null) {
            if (this.getValueOptions() != null) {
                controlType = "select";
            } else {
                DataType dataType = this.column.getDataType();
                controlType = FacesUtils.getFacesApplication().getDefaultControlType(dataType);
            }
            control = InputControlManager.getControl(controlType);
            if (control == null) {
                control = InputControlManager.getControl("text");
            }
            if (log.isDebugEnabled() && !controlType.equals("text")) {
                log.debug("Auto-detected field control for " + this.column.getName() + " is " + controlType);
            }
        }
        return control;
    }

    public InputControl.ValueInfo getValueInfo(FacesContext ctx) {
        return new ValueInfoImpl(this.getColumn(), this.getTextResolver(ctx));
    }

    public InputControl.InputInfo getInputInfo(FacesContext ctx) {
        return new InputInfoImpl(this.getColumn(), this.getTextResolver(ctx));
    }

    public boolean hasColumn() {
        if (this.column == null) {
            this.column = this.findColumn();
        }
        return this.column != null;
    }

    public Column getColumn() {
        if (this.column == null) {
            this.column = this.findColumn();
        }
        if (this.column == null) {
            throw new InvalidArgumentException("column", (Object)this.column);
        }
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public Object getRecord() {
        if (this.record == null) {
            this.record = this.findRecord();
        }
        return this.record;
    }

    public void setRecord(Object record) {
        this.record = record;
    }

    public RecordTag getRecordComponent() {
        if (this.recordTag != null) {
            return this.recordTag;
        }
        if (this.record != null || this.tag.getAttributes().containsKey("record")) {
            return null;
        }
        UIOutput parent = this.tag;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof RecordTag)) continue;
            this.recordTag = (RecordTag)parent;
            return this.recordTag;
        }
        return null;
    }

    public Object getDataValue(boolean evalExpression) {
        if (this.getRecord() != null) {
            if (this.record instanceof RecordData) {
                return ((RecordData)this.record).getValue((ColumnExpr)this.getColumn());
            }
            String prop = this.getColumn().getBeanPropertyName();
            return this.getBeanPropertyValue(this.record, prop);
        }
        if (evalExpression) {
            return this.tag.getValue();
        }
        Object value = this.tag.getLocalValue();
        if (value == null) {
            value = this.findValueExpression();
        }
        return value;
    }

    public void setDataValue(Object value) {
        if (this.getRecord() != null) {
            if (this.record instanceof Record) {
                ((Record)this.record).setValue(this.getColumn(), value);
            } else {
                if (this.record instanceof RecordData) {
                    throw new PropertyReadOnlyException("record");
                }
                String prop = this.getColumn().getBeanPropertyName();
                this.setBeanPropertyValue(this.record, prop, value);
            }
        } else {
            ValueExpression ve = this.tag.getValueExpression("value");
            if (ve == null) {
                throw new PropertyReadOnlyException("value");
            }
            FacesContext ctx = FacesContext.getCurrentInstance();
            ve.setValue(ctx.getELContext(), value);
        }
    }

    public boolean isRecordReadOnly() {
        if (!(this.tag instanceof UIInput)) {
            return true;
        }
        Object val = this.tag.getAttributes().get("readonly");
        if (val != null && ObjectUtils.getBoolean(val)) {
            return true;
        }
        if (this.getRecord() instanceof RecordData ? !(this.record instanceof Record) || ((Record)this.record).isReadOnly() : !this.hasValueAttribute() || this.hasValueExpr == null) {
            return true;
        }
        return this.recordTag != null && this.recordTag.isReadOnly();
    }

    public boolean isReadOnly() {
        Record r;
        Object val = this.tag.getAttributes().get("disabled");
        if (val != null && ObjectUtils.getBoolean(val)) {
            return true;
        }
        if (this.isRecordReadOnly()) {
            return true;
        }
        if (this.record instanceof Record && (r = (Record)this.record).isFieldReadOnly(this.getColumn())) {
            return true;
        }
        return this.getColumn().isReadOnly();
    }

    public boolean isValueRequired() {
        Object required = this.tag.getAttributes().get("mandatory");
        if (required != null) {
            return ObjectUtils.getBoolean(required);
        }
        if (this.isReadOnly()) {
            return false;
        }
        if (this.hasValueAttribute() && this.hasValueExpr.booleanValue()) {
            return false;
        }
        return this.column.isRequired();
    }

    protected Column findColumn() {
        Object col = this.tag.getAttributes().get("column");
        if (col instanceof Column) {
            return (Column)col;
        }
        if (col instanceof String) {
            String name = String.valueOf(col);
            int dbix = name.indexOf(46);
            if (dbix <= 0) {
                log.error("Invalid column expression '{}'!", (Object)name);
                return null;
            }
            DBDatabase db = DBDatabase.findById((String)name.substring(0, dbix));
            if (db == null) {
                log.error("Database '{}' not found!", (Object)name.substring(0, dbix));
                return null;
            }
            int co = name.lastIndexOf(46);
            int to = name.lastIndexOf(46, co - 1);
            String cn = name.substring(co + 1);
            String tn = name.substring(to + 1, co);
            DBRowSet rs = db.getRowSet(tn);
            if (rs == null) {
                log.error("Table/View '{}' not found in database!", (Object)tn);
                return null;
            }
            DBColumn column = rs.getColumn(cn);
            if (column == null) {
                log.error("Column '{}' not found in table/view '{}'!", (Object)cn, (Object)tn);
                return null;
            }
            return column;
        }
        if (col == null) {
            col = this.tag.getValue();
            if (col instanceof Column) {
                return (Column)col;
            }
            if (col instanceof ColumnExpr) {
                Column source = ((ColumnExpr)col).getSourceColumn();
                if (source != null) {
                    return source;
                }
                return new ColumnExprWrapper((ColumnExpr)col);
            }
        }
        if (log.isDebugEnabled() && !(this.tag instanceof LinkTag)) {
            log.warn("No Column provided for value tag!");
        }
        return null;
    }

    protected Object findRecord() {
        RecordTag recordComponent;
        Object rec = this.tag.getAttributes().get("record");
        if (rec == null && this.hasValueAttribute()) {
            return null;
        }
        if (rec == null && (recordComponent = this.getRecordComponent()) != null) {
            rec = recordComponent.getRecord();
        }
        return rec;
    }

    protected boolean hasValueAttribute() {
        if (this.tag.getAttributes().containsKey("value")) {
            return true;
        }
        if (this.hasValueExpr != null) {
            return this.hasValueExpr;
        }
        ValueExpression ve = this.findValueExpression();
        if (ve != null && log.isDebugEnabled()) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            boolean readOnly = ve.isReadOnly(ctx.getELContext());
            if (readOnly) {
                log.debug(this.tag.getClass().getSimpleName() + " for " + this.getColumn().getName() + " expression " + ve.getExpressionString() + " is readOnly!");
            } else {
                log.debug(this.tag.getClass().getSimpleName() + " for " + this.getColumn().getName() + " expression " + ve.getExpressionString() + " is updateable!");
            }
        }
        this.hasValueExpr = new Boolean(ve != null);
        return this.hasValueExpr;
    }

    protected ValueExpression findValueExpression() {
        ValueExpression ve = this.tag.getValueExpression("value");
        if (ve == null) {
            return null;
        }
        UIOutput parent = this.tag;
        String expr = ve.getExpressionString();
        while (expr.startsWith(CC_ATTR_EXPR)) {
            if ((parent = UIComponent.getCompositeComponentParent((UIComponent)parent)) == null) {
                return null;
            }
            int end = expr.indexOf(125);
            String attrib = expr.substring(CC_ATTR_EXPR.length(), end);
            ve = parent.getValueExpression(attrib);
            if (ve == null) {
                return null;
            }
            expr = ve.getExpressionString();
        }
        return ve;
    }

    protected Options getValueOptions() {
        Object attr = this.tag.getAttributes().get("options");
        if (attr != null && attr instanceof Options) {
            return (Options)attr;
        }
        if (this.getColumn() != null) {
            if (this.getRecord() instanceof Record) {
                return ((Record)this.record).getFieldOptions(this.column);
            }
            return this.column.getOptions();
        }
        return null;
    }

    protected Object getBeanPropertyValue(Object bean, String property) {
        try {
            PropertyUtilsBean pub = BeanUtilsBean.getInstance().getPropertyUtils();
            return pub.getSimpleProperty(bean, property);
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.warn(bean.getClass().getName() + ": no getter available for property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
    }

    protected void setBeanPropertyValue(Object bean, String property, Object value) {
        try {
            if (ObjectUtils.isEmpty((Object)value)) {
                value = null;
            }
            if (value != null) {
                BeanUtils.setProperty((Object)bean, (String)property, (Object)value);
            } else {
                PropertyUtils.setProperty((Object)bean, (String)property, null);
            }
        }
        catch (IllegalArgumentException e) {
            log.error(bean.getClass().getName() + ": invalid argument for property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error(bean.getClass().getName() + ": no setter available for property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
    }

    public String getValueTooltip(Object value) {
        String text;
        Options options;
        if (value == null) {
            return null;
        }
        String templ = StringUtils.valueOf((Object)value);
        int valIndex = templ.indexOf("{}");
        if (valIndex >= 0) {
            value = this.getDataValue(true);
        }
        if ((options = this.getValueOptions()) != null && !this.hasFormat("notitlelookup")) {
            String optValue = options.get(value);
            text = this.getDisplayText(optValue);
        } else {
            text = this.getDisplayText(StringUtils.toString((Object)value));
        }
        if (valIndex >= 0 && text != null) {
            text = StringUtils.replace((String)templ, (String)"{}", (String)text);
        }
        return text;
    }

    public String getLabelTooltip(Column column) {
        Object title = this.tag.getAttributes().get("title");
        if (title != null) {
            return this.getDisplayText(StringUtils.toString(title));
        }
        if (this.hasFormat("short") && !ObjectUtils.isEmpty((Object)column.getAttribute(COLATTR_ABBR_TITLE))) {
            return this.getDisplayText(column.getTitle());
        }
        return null;
    }

    public boolean hasFormat(String format) {
        Object f = this.tag.getAttributes().get("format");
        return f != null && String.valueOf(f).indexOf(format) >= 0;
    }

    public boolean hasFormat(InputControl.ValueInfo vi, String format) {
        String f = vi.getFormat();
        return f != null && f.indexOf(format) >= 0;
    }

    public void writeAttribute(ResponseWriter writer, String attribute, Object value) throws IOException {
        if (value != null) {
            writer.writeAttribute(attribute, value, null);
        }
    }

    public String getDisplayText(String text) {
        if (this.textResolver == null) {
            this.getTextResolver(FacesContext.getCurrentInstance());
        }
        return this.textResolver.resolveText(text);
    }

    public TextResolver getTextResolver(FacesContext context) {
        if (this.textResolver == null) {
            this.textResolver = ((FacesApplication)context.getApplication()).getTextResolver(context);
        }
        return this.textResolver;
    }

    public void addErrorMessage(FacesContext context, Exception e) {
        String msgText = this.getTextResolver(context).getExceptionMessage(e);
        FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msgText, msgText);
        context.addMessage(this.tag.getClientId(), msg);
    }

    public String getTagAttribute(String name, String defValue) {
        Object v = this.tag.getAttributes().get(name);
        return v != null ? StringUtils.toString(v) : defValue;
    }

    public String getTagAttribute(String name) {
        return this.getTagAttribute(name, null);
    }

    protected String getLabelValue(Column column, boolean colon) {
        String label = this.getTagAttribute("label");
        if (label != null) {
            return label;
        }
        if (this.hasFormat("short") && (label = StringUtils.toString((Object)column.getAttribute(COLATTR_ABBR_TITLE))) == null) {
            log.warn("No Abbreviation available for column {}. Using normal title.", (Object)column.getName());
        }
        if (label == null) {
            label = column.getTitle();
        }
        if (StringUtils.isEmpty((String)(label = this.getDisplayText(label)))) {
            return CSS_DATA_TYPE_NONE;
        }
        if (colon) {
            label = label.trim() + ":";
        }
        return label;
    }

    public HtmlOutputLabel createLabelComponent(FacesContext context, String forInput, String styleClass, String style, boolean colon) {
        String title;
        HtmlOutputLabel label;
        UIComponent input;
        Column column = null;
        boolean readOnly = false;
        boolean required = false;
        if (StringUtils.isNotEmpty((String)forInput) && !forInput.equals("*") && (input = FacesUtils.getFacesApplication().findComponent(context, forInput, (UIComponent)this.tag)) != null && input instanceof InputTag) {
            InputTag inputTag = (InputTag)input;
            column = inputTag.getInputColumn();
            readOnly = inputTag.isInputReadOnly();
            required = inputTag.isInputRequired();
        }
        if (column == null) {
            column = this.getColumn();
            required = this.isValueRequired();
        }
        if (column == null) {
            throw new InvalidArgumentException("column", (Object)column);
        }
        try {
            label = InputControlManager.getLabelComponentClass().newInstance();
        }
        catch (InstantiationException e1) {
            throw new InternalException((Throwable)e1);
        }
        catch (IllegalAccessException e2) {
            throw new InternalException((Throwable)e2);
        }
        String labelText = this.getLabelValue(column, colon);
        if (StringUtils.isEmpty((String)labelText)) {
            label.setRendered(false);
        } else {
            label.setValue((Object)labelText);
        }
        if (StringUtils.isNotEmpty((String)styleClass)) {
            label.setStyleClass(styleClass);
        }
        if (StringUtils.isNotEmpty((String)forInput) && !readOnly) {
            String inputId = this.getInputInfo(context).getInputId();
            if (forInput.equals("*")) {
                label.setFor(inputId);
            } else {
                label.setFor(forInput + ":" + inputId);
            }
        }
        if (StringUtils.isNotEmpty((String)style)) {
            label.setStyle(style);
        }
        if ((title = this.getLabelTooltip(column)) != null) {
            label.setTitle(title);
        }
        if (required) {
            HtmlPanelGroup span = new HtmlPanelGroup();
            span.setStyleClass("required");
            HtmlOutputText text = new HtmlOutputText();
            text.setValue((Object)"*");
            span.getChildren().add(text);
            label.getChildren().add(span);
        }
        return label;
    }

    public static String getTagStyleClass(String tagCssStyle, String typeClass, String addlStyle, String userStyle) {
        if (StringUtils.isEmpty((String)userStyle) && StringUtils.isEmpty((String)addlStyle)) {
            return StringUtils.isEmpty((String)typeClass) ? tagCssStyle : tagCssStyle + typeClass;
        }
        StringBuilder b = new StringBuilder(tagCssStyle);
        if (StringUtils.isNotEmpty((String)typeClass)) {
            b.append(typeClass);
        }
        if (StringUtils.isNotEmpty((String)addlStyle)) {
            b.append(" ");
            b.append(addlStyle);
        }
        if (StringUtils.isNotEmpty((String)userStyle)) {
            b.append(" ");
            b.append(userStyle);
        }
        return b.toString();
    }

    private static String getDataTypeClass(DataType type) {
        switch (type) {
            case AUTOINC: {
                return CSS_DATA_TYPE_IDENT;
            }
            case INTEGER: 
            case DECIMAL: 
            case FLOAT: {
                return CSS_DATA_TYPE_NUMBER;
            }
            case TEXT: 
            case CHAR: {
                return CSS_DATA_TYPE_TEXT;
            }
            case DATE: 
            case DATETIME: {
                return CSS_DATA_TYPE_DATE;
            }
            case BOOL: {
                return CSS_DATA_TYPE_BOOL;
            }
            case CLOB: {
                return CSS_DATA_TYPE_LONGTEXT;
            }
        }
        return CSS_DATA_TYPE_NONE;
    }

    public final String getTagStyleClass(DataType dataType, String addlStyle, String userStyle) {
        String typeClass = TagEncodingHelper.getDataTypeClass(dataType);
        return TagEncodingHelper.getTagStyleClass(this.tagCssStyle, typeClass, addlStyle, userStyle);
    }

    public final String getTagStyleClass(DataType dataType) {
        String userStyle = StringUtils.toString(this.tag.getAttributes().get("styleClass"));
        String typeClass = TagEncodingHelper.getDataTypeClass(dataType);
        return TagEncodingHelper.getTagStyleClass(this.tagCssStyle, typeClass, null, userStyle);
    }

    public final String getTagStyleClass(String addlStyle) {
        String userStyle = StringUtils.toString(this.tag.getAttributes().get("styleClass"));
        String typeClass = this.hasColumn() ? TagEncodingHelper.getDataTypeClass(this.column.getDataType()) : null;
        return TagEncodingHelper.getTagStyleClass(this.tagCssStyle, typeClass, addlStyle, userStyle);
    }

    public final String getTagStyleClass() {
        String userStyle = StringUtils.toString(this.tag.getAttributes().get("styleClass"));
        String typeClass = this.hasColumn() ? TagEncodingHelper.getDataTypeClass(this.column.getDataType()) : null;
        return TagEncodingHelper.getTagStyleClass(this.tagCssStyle, typeClass, null, userStyle);
    }

    private class InputInfoImpl
    extends ValueInfoImpl
    implements InputControl.InputInfo {
        public InputInfoImpl(Column column, TextResolver resolver) {
            super(column, resolver);
        }

        @Override
        public void setValue(Object value) {
            TagEncodingHelper.this.setDataValue(value);
        }

        @Override
        public void validate(Object value) {
            boolean isNull = ObjectUtils.isEmpty((Object)value);
            if (isNull && !this.isRequired()) {
                return;
            }
            TagEncodingHelper.this.column.validate(value);
        }

        @Override
        public boolean isRequired() {
            return TagEncodingHelper.this.isValueRequired();
        }

        @Override
        public boolean isDisabled() {
            return TagEncodingHelper.this.isReadOnly();
        }

        @Override
        public String getInputId() {
            Column c = this.getColumn();
            return c.getName();
        }

        @Override
        public String getTabindex() {
            Object size = TagEncodingHelper.this.tag.getAttributes().get("tabindex");
            return StringUtils.toString(size);
        }

        @Override
        public String getStyleClass(String addlStyle) {
            return TagEncodingHelper.this.getTagStyleClass(addlStyle);
        }
    }

    private class ValueInfoImpl
    implements InputControl.ValueInfo {
        public ValueInfoImpl(Column column, TextResolver resolver) {
            if (column == null) {
                throw new InvalidArgumentException("column", (Object)resolver);
            }
            if (resolver == null) {
                throw new InvalidArgumentException("resolver", (Object)resolver);
            }
        }

        private boolean hasColumn() {
            return TagEncodingHelper.this.column != null || this.getColumn() != null;
        }

        @Override
        public Column getColumn() {
            return TagEncodingHelper.this.column;
        }

        @Override
        public Object getValue(boolean evalExpression) {
            return TagEncodingHelper.this.getDataValue(evalExpression);
        }

        @Override
        public Options getOptions() {
            return TagEncodingHelper.this.getValueOptions();
        }

        @Override
        public String getFormat() {
            Object format;
            Object attr = TagEncodingHelper.this.tag.getAttributes().get("format");
            if (attr != null) {
                return attr.toString();
            }
            if (this.hasColumn() && (format = TagEncodingHelper.this.column.getAttribute("format")) != null) {
                return format.toString();
            }
            return null;
        }

        @Override
        public Locale getLocale() {
            return TagEncodingHelper.this.textResolver.getLocale();
        }

        @Override
        public String getText(String text) {
            return TagEncodingHelper.this.textResolver.resolveText(text);
        }
    }

    private static class ColumnExprWrapper
    implements Column {
        private final ColumnExpr expr;

        public ColumnExprWrapper(ColumnExpr expr) {
            this.expr = expr;
        }

        public DataType getDataType() {
            return this.expr.getDataType();
        }

        public String getName() {
            return this.expr.getName();
        }

        public String getTitle() {
            return this.expr.getTitle();
        }

        public String getControlType() {
            return this.expr.getControlType();
        }

        public Object getAttribute(String name) {
            return this.expr.getAttribute(name);
        }

        public Options getOptions() {
            return this.expr.getOptions();
        }

        public String getBeanPropertyName() {
            return this.expr.getBeanPropertyName();
        }

        public Column getSourceColumn() {
            return this.expr.getSourceColumn();
        }

        public double getSize() {
            return 0.0;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        public void validate(Object value) {
        }
    }
}

