/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.utils;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.empire.commons.DateUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ParameterMap.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss", Locale.GERMAN);
    private static MessageDigest md5 = null;
    private final byte[] salt;
    private Hashtable<String, String> codeMap;
    private final Hashtable<String, Hashtable<String, Object>> typeMap;

    public ParameterMap() {
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("MessageDigest NoSuchAlgorithmException.", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.codeMap = new Hashtable();
        this.typeMap = new Hashtable();
        String dateTime = dateFormat.format(DateUtils.getTimeNow());
        this.salt = dateTime.getBytes();
    }

    public synchronized String encodeString(String valueAsString) {
        if (valueAsString == null) {
            throw new InvalidArgumentException("valueAsString", (Object)valueAsString);
        }
        if (log.isTraceEnabled()) {
            log.trace("Generating code for value {}.", (Object)valueAsString);
        }
        md5.reset();
        if (this.salt != null) {
            md5.update(this.salt);
        }
        md5.update(valueAsString.getBytes());
        byte[] s = md5.digest();
        StringBuilder hash = new StringBuilder(32);
        block4: for (int i = 0; i < s.length; ++i) {
            String part = Integer.toHexString(0xFF & s[i]);
            switch (part.length()) {
                case 1: {
                    hash.append('0');
                }
                case 2: {
                    hash.append(part);
                    continue block4;
                }
                default: {
                    throw new UnexpectedReturnValueException((Object)part, "Integer.toHexString");
                }
            }
        }
        return hash.toString();
    }

    public String encodeStringWithCache(String valueAsString) {
        String code = this.codeMap.get(valueAsString);
        if (code == null) {
            code = this.encodeString(valueAsString);
            this.codeMap.put(valueAsString, code);
        }
        return code;
    }

    private void putValue(String typeName, String key, Object value) {
        Hashtable<String, Object> map = this.typeMap.get(typeName);
        if (map == null) {
            map = new Hashtable(1);
            this.typeMap.put(typeName, map);
        }
        if (key == null || value == null) {
            log.warn("Key or value is null.");
        }
        map.put(key, value);
    }

    public String put(String type, String key, boolean useCache) {
        String id = useCache ? this.encodeStringWithCache(key) : this.encodeString(key);
        this.putValue(type, id, key);
        return id;
    }

    public String put(Class<? extends Object> c, Object[] key) {
        String ref = StringUtils.valueOf((Object[])key);
        String id = this.encodeString(ref);
        String type = c.getSimpleName();
        this.putValue(type, id, key);
        return id;
    }

    public String put(DBRowSet rowset, Object[] key) {
        String ref = StringUtils.valueOf((Object[])key);
        String id = this.encodeString(ref);
        String type = rowset.getClass().getSimpleName();
        this.putValue(type, id, key);
        return id;
    }

    public Object get(String type, String id) {
        Hashtable<String, Object> map = this.typeMap.get(type);
        return map != null ? map.get(id) : null;
    }

    public Object[] get(Class<? extends Object> c, String id) {
        String type = c.getSimpleName();
        Hashtable<String, Object> map = this.typeMap.get(type);
        return map != null ? (Object[])map.get(id) : null;
    }

    public Object[] get(DBRowSet rowset, String id) {
        String type = rowset.getClass().getSimpleName();
        Hashtable<String, Object> map = this.typeMap.get(type);
        return map != null ? (Object[])map.get(id) : null;
    }

    public void clear(Class<? extends Object> c) {
        String type = c.getSimpleName();
        Hashtable<String, Object> map = this.typeMap.get(type);
        if (map != null) {
            map.clear();
        }
    }

    public void clear(DBRowSet rowset) {
        String type = rowset.getClass().getSimpleName();
        Hashtable<String, Object> map = this.typeMap.get(type);
        if (map != null) {
            map.clear();
        }
    }
}

