/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pages;

import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.pages.Page;
import org.apache.empire.jsf2.pages.PageDefinition;
import org.apache.empire.jsf2.pages.PageDefinitions;
import org.apache.empire.jsf2.pages.PageNavigationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagePhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(PagePhaseListener.class);
    private static final String LAST_PAGE_VIEW_ID = "lastPageViewId";
    public static final String FORWARD_PAGE_PARAMS = "forwardPageParams";

    public PagePhaseListener() {
        log.trace("PagePhaseListener created.");
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent pe) {
        PageDefinition pageDef;
        FacesContext fc;
        UIViewRoot vr;
        PhaseId phaseId = pe.getPhaseId();
        if (log.isTraceEnabled()) {
            log.trace("Processing Phase {}.", (Object)phaseId);
        }
        if ((vr = (fc = pe.getFacesContext()).getViewRoot()) == null) {
            return;
        }
        String viewId = vr.getViewId();
        Map sessionMap = fc.getExternalContext().getSessionMap();
        Object lastViewId = sessionMap.get(LAST_PAGE_VIEW_ID);
        if (lastViewId == null || !((String)lastViewId).equalsIgnoreCase(viewId)) {
            FacesUtils.getFacesApplication().onChangeView(fc, viewId);
            if (fc.getResponseComplete()) {
                return;
            }
            sessionMap.put(LAST_PAGE_VIEW_ID, viewId);
        }
        if ((pageDef = PageDefinitions.getInstance().getPageFromViewId(viewId)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("No page definition available for viewId {}.", (Object)viewId);
            }
            return;
        }
        String name = pageDef.getPageBeanName();
        Map viewMap = vr.getViewMap();
        Page pageBean = (Page)viewMap.get(name);
        if (pageBean == null) {
            String pageBeanClassName = pageDef.getPageBeanClass().getName();
            if (log.isDebugEnabled()) {
                log.debug("Creating page bean {} for {} in Phase {}.", new Object[]{pageBeanClassName, viewId, pe.getPhaseId()});
            }
            try {
                pageBean = pageDef.getPageBeanClass().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating instance of page bean " + pageBeanClassName, e);
            }
            viewMap.put(pageDef.getPageBeanName(), pageBean);
            viewMap.put("page", pageBean);
        }
        pageBean.setPageDefinition(pageDef);
        if (pe.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.initPageBean(pageBean, fc, viewMap);
        }
    }

    private void initPageBean(Page pageBean, FacesContext fc, Map<String, Object> viewMap) {
        if (!pageBean.isInitialized()) {
            Map pageParams;
            if (!PageNavigationHandler.isInitialized()) {
                log.error("PageNavigationHandler has not been initialized. Forward operations will not work!");
            }
            if (viewMap.containsKey(FORWARD_PAGE_PARAMS) && !this.setViewMetadata(pageParams = (Map)viewMap.remove(FORWARD_PAGE_PARAMS))) {
                for (String name : pageParams.keySet()) {
                    String value = (String)pageParams.get(name);
                    try {
                        BeanUtils.setProperty((Object)pageBean, (String)name, (Object)value);
                    }
                    catch (Exception e) {
                        log.error("Unable to set PageParam " + name + " on " + pageBean.getClass().getName() + ".", (Throwable)e);
                    }
                }
            }
        }
        pageBean.preRenderPage(fc);
    }

    private boolean setViewMetadata(Map<String, String> pageParams) {
        return false;
    }

    public void afterPhase(PhaseEvent pe) {
        if (pe.getPhaseId() != PhaseId.RENDER_RESPONSE) {
            return;
        }
        UIViewRoot vr = pe.getFacesContext().getViewRoot();
        Map viewMap = vr.getViewMap();
        Page pageBean = (Page)viewMap.get("page");
        if (pageBean != null && !pageBean.isInitialized()) {
            log.warn("PageBean was not initialized!");
            throw new RuntimeException("PageBean was not initialized!");
        }
        log.trace("PagePhase complete.");
    }
}

