/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pages;

import java.io.Serializable;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.pages.Page;
import org.apache.empire.jsf2.pages.PageDefinitions;
import org.apache.empire.jsf2.pages.PageOutcome;
import org.apache.empire.jsf2.utils.ParameterMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(PageDefinitions.class);
    private static final String ACTION_PARAMETER_TYPE = "ACTION";
    private final String path;
    private final String fileExtension;
    private final String pageBeanName;
    private final Class<? extends Page> pageBeanClass;
    private final PageDefinition parent;

    private static String encodeActionParam(String action) {
        ParameterMap pm = FacesUtils.getParameterMap(FacesUtils.getContext());
        if (pm == null) {
            return action;
        }
        return pm.put(ACTION_PARAMETER_TYPE, action, true);
    }

    public static String decodeActionParam(String param) {
        ParameterMap pm = FacesUtils.getParameterMap(FacesUtils.getContext());
        if (pm == null) {
            return param;
        }
        String action = StringUtils.valueOf((Object)pm.get(ACTION_PARAMETER_TYPE, param));
        if (action == null) {
            log.warn("no action available for param {}.", (Object)param);
        }
        return action;
    }

    public PageDefinition(String path, Class<? extends Page> pageBeanClass, PageDefinition parent, String pageBeanName) {
        this.path = path;
        this.pageBeanClass = pageBeanClass;
        this.parent = parent;
        int ext = path.lastIndexOf(46);
        this.fileExtension = ext > 0 ? path.substring(ext) : null;
        this.pageBeanName = pageBeanName == null ? this.getPageBeanNameFromPath(path, this.fileExtension) : pageBeanName;
        PageDefinitions.registerPage(this);
    }

    public PageDefinition(String path, Class<? extends Page> pageBeanClass, String pageBeanName) {
        this(path, pageBeanClass, null, pageBeanName);
    }

    public PageDefinition(String path, Class<? extends Page> pageBeanClass, PageDefinition parent) {
        this(path, pageBeanClass, parent, null);
    }

    public PageDefinition(String path, Class<? extends Page> pageBeanClass) {
        this(path, pageBeanClass, null, null);
    }

    protected String getPageBeanNameFromPath(String path, String extension) {
        int lastSlash = path.lastIndexOf(47);
        String name = path.substring(lastSlash + 1);
        if (extension != null) {
            name = name.substring(0, name.length() - extension.length());
        }
        return name;
    }

    public String getPath() {
        return this.path;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getPageBeanName() {
        return this.pageBeanName;
    }

    public Class<? extends Page> getPageBeanClass() {
        return this.pageBeanClass;
    }

    public PageDefinition getParent() {
        return this.parent;
    }

    public PageOutcome getOutcome() {
        String uri = PageDefinitions.getInstance().getPageUri(this);
        return new PageOutcome(uri);
    }

    public PageOutcome getOutcome(String action) {
        PageOutcome outcome = this.getOutcome();
        if (StringUtils.isNotEmpty((String)action)) {
            outcome = outcome.addParam("action", PageDefinition.encodeActionParam(action));
        }
        return outcome;
    }

    public PageOutcome getRedirect() {
        PageOutcome outcome = this.getOutcome();
        outcome = outcome.addParamWithValue("faces-redirect=true");
        return outcome;
    }

    public PageOutcome getRedirect(String action) {
        PageOutcome outcome = this.getRedirect();
        if (StringUtils.isNotEmpty((String)action)) {
            outcome = outcome.addParam("action", PageDefinition.encodeActionParam(action));
        }
        return outcome;
    }

    public PageOutcome getRedirectWithViewParams() {
        PageOutcome outcome = this.getRedirect();
        outcome = outcome.addParamWithValue("includeViewParams=true");
        return outcome;
    }

    public PageOutcome getRedirectWithViewParams(String action) {
        PageOutcome outcome = this.getRedirectWithViewParams();
        if (StringUtils.isNotEmpty((String)action)) {
            outcome = outcome.addParam("action", PageDefinition.encodeActionParam(action));
        }
        return outcome;
    }

    public String toString() {
        return this.getOutcome().toString();
    }
}

