/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pageelements;

import java.sql.Connection;
import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.jsf2.pages.Page;
import org.apache.empire.jsf2.pages.PageElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordPageElement<T extends DBRecord>
extends PageElement {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(RecordPageElement.class);
    protected DBRowSet rowset;
    protected T record;

    public RecordPageElement(Page page, DBRowSet rowset, T record, String propertyName) {
        super(page, propertyName);
        this.rowset = rowset;
        this.record = record;
        log.debug("RecordPageSupport for {} created.", (Object)rowset.getName());
    }

    public T getRecord() {
        return this.record;
    }

    public DBRowSet getRowSet() {
        return this.record.getRowSet();
    }

    @Override
    protected void onInitPage() {
        if (!this.record.isValid()) {
            this.reloadRecord();
        }
    }

    public void reloadRecord() {
        Object[] recKey = this.getSessionObject(Object[].class);
        if (recKey == null || recKey.length == 0) {
            throw new ObjectNotValidException((Object)this);
        }
        Connection conn = this.getPage().getConnection(this.rowset.getDatabase());
        this.record.read(this.rowset, recKey, conn);
    }

    public void loadRecord(Object[] recKey) {
        if (recKey == null || recKey.length == 0) {
            throw new InvalidArgumentException("recKey", recKey);
        }
        this.setSessionObject(Object[].class, recKey);
        Connection conn = this.getPage().getConnection(this.rowset.getDatabase());
        this.record.read(this.rowset, recKey, conn);
    }

    public void createRecord() {
        this.record.create(this.rowset);
    }

    public void loadRecord(String idParam) {
        Object[] key = this.getPage().getKeyFromParam(this.rowset, idParam);
        this.loadRecord(key);
    }

    public String getRecordIdParam() {
        if (!this.record.isValid()) {
            return null;
        }
        Object[] key = this.record.getKeyValues();
        return this.getPage().getIdParamForKey(this.rowset, key);
    }
}

