/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pageelements;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.event.ActionEvent;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.jsf2.pages.Page;
import org.apache.empire.jsf2.pages.PageElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ListPageElement<T>
extends PageElement {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ListPageElement.class);
    protected Class<T> beanClass;
    protected List<T> items = null;
    protected SelectionSet selectedItems = null;

    public ListPageElement(Page page, Class<T> beanClass, String propertyName) {
        super(page, propertyName);
        this.beanClass = beanClass;
        if (ListPageElement.isSelectableItem(beanClass)) {
            this.selectedItems = new SelectionSet();
        }
    }

    private static <T> boolean isSelectableItem(Class<T> beanClass) {
        for (Class<T> superClass = beanClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!superClass.equals(SelectableItem.class)) continue;
            return true;
        }
        return false;
    }

    public abstract ListTableInfo getTableInfo();

    public List<T> getItems() {
        if (this.items == null) {
            log.warn("Bean List has not been initialized!");
        }
        return this.items;
    }

    public final boolean isValid() {
        return this.items == null ? false : this.items.size() > 0;
    }

    public int getItemCount() {
        return this.getTableInfo().getItemCount();
    }

    public void clearItems() {
        this.clearSelection();
        this.items = null;
    }

    public void clearSelection() {
        if (this.selectedItems != null) {
            this.selectedItems.clear();
        }
    }

    public boolean isHasSelection() {
        if (this.selectedItems == null) {
            return false;
        }
        return this.selectedItems.size() > 0 || this.selectedItems.isInvertSelection();
    }

    public int getSelectedItemCount() {
        if (this.selectedItems == null) {
            return 0;
        }
        return this.selectedItems.size();
    }

    public Set<Object[]> getSelectedItems() {
        throw new NotSupportedException((Object)this, "getSelectedItems");
    }

    public boolean isInvertSelection() {
        if (this.selectedItems == null) {
            return false;
        }
        return this.selectedItems.isInvertSelection();
    }

    public void setInvertSelection(boolean invertSelection) {
        if (this.selectedItems == null) {
            throw new NotSupportedException((Object)this, "setInvertSelection");
        }
        this.selectedItems.setInvertSelection(invertSelection);
    }

    protected void assignSelectionMap(List<?> items) {
        if (this.selectedItems == null) {
            return;
        }
        for (Object item : items) {
            if (!(item instanceof SelectableItem)) continue;
            ((SelectableItem)item).setSelectMap(this.selectedItems);
        }
    }

    public static class ListTableInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int itemCount = -1;
        private boolean valid = false;
        private boolean modified = false;
        private String sortColumnName;
        private boolean sortAscending = true;
        private boolean sortOrderChanged = false;
        private int position = 0;
        private int pageSize = 0;

        public void init(int itemCount, int pageSize) {
            if (pageSize < 0) {
                throw new ObjectNotValidException((Object)this);
            }
            this.itemCount = itemCount;
            this.pageSize = pageSize;
            this.position = 0;
            this.valid = itemCount >= 0;
            this.modified = false;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            if (valid && this.itemCount < 0) {
                throw new ObjectNotValidException((Object)this);
            }
            this.valid = valid;
        }

        public boolean isModified() {
            return this.valid && this.modified;
        }

        public void setModified(boolean modified) {
            this.modified = modified;
        }

        public int getItemCount() {
            return this.itemCount;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public String getSortColumnName() {
            return this.sortColumnName;
        }

        public void setSortColumnName(String column) {
            if (ObjectUtils.compareEqual((Object)column, (Object)this.sortColumnName)) {
                return;
            }
            this.sortColumnName = column;
            this.position = 0;
            this.modified = true;
            this.sortOrderChanged = true;
        }

        public boolean getSortAscending() {
            return this.sortAscending;
        }

        public void setSortAscending(boolean sortAscending) {
            if (this.sortAscending == sortAscending) {
                return;
            }
            this.sortAscending = sortAscending;
            this.modified = true;
            this.sortOrderChanged = true;
        }

        public boolean isSortOrderChanged() {
            return this.sortOrderChanged;
        }

        public void setSortOrderChanged(boolean sortOrderChanged) {
            this.sortOrderChanged = sortOrderChanged;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            if (this.pageSize == 0) {
                throw new NotSupportedException((Object)this, "setPosition");
            }
            if (position < 0) {
                position = 0;
            }
            if (position >= this.itemCount) {
                position = this.itemCount - 1;
            }
            if (this.position == position) {
                return;
            }
            this.position = position;
            this.modified = true;
        }

        public boolean isAllowPagination() {
            return this.pageSize > 0;
        }

        public boolean isHasNextPage() {
            if (this.isValid() && this.isAllowPagination()) {
                return this.itemCount - (this.position + this.pageSize) > 0;
            }
            return false;
        }

        public boolean isHasPrevPage() {
            return this.isValid() && this.isAllowPagination() && this.position > 0;
        }

        public void nextPage(ActionEvent e) {
            if (!this.isAllowPagination()) {
                throw new NotSupportedException((Object)this, "nextPage");
            }
            if (this.position + this.pageSize > this.itemCount) {
                return;
            }
            this.position += this.pageSize;
            this.modified = true;
        }

        public void prevPage(ActionEvent e) {
            if (!this.isAllowPagination()) {
                throw new NotSupportedException((Object)this, "prevPage");
            }
            if (this.position == 0) {
                return;
            }
            this.position = this.position > this.pageSize ? (this.position -= this.pageSize) : 0;
            this.modified = true;
        }

        public int getPageNumber() {
            if (!this.isAllowPagination()) {
                return 1;
            }
            int pageNumber = new Double(Math.ceil((double)this.position / (double)this.pageSize)).intValue() + 1;
            return pageNumber;
        }

        public int getPageCount() {
            if (!this.isAllowPagination()) {
                return 1;
            }
            int pageCount = new Double(Math.ceil((double)this.itemCount / (double)this.pageSize)).intValue();
            return pageCount;
        }
    }

    public static abstract class SelectableItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private SelectionSet selectSet = null;

        protected void setSelectMap(SelectionSet selectSet) {
            this.selectSet = selectSet;
        }

        public boolean isSelected() {
            String id = this.getIdParam();
            return this.selectSet.contains(id);
        }

        public void setSelected(boolean selected) {
            String id = this.getIdParam();
            if (selected != this.selectSet.isInvertSelection()) {
                this.selectSet.add(id);
            } else {
                this.selectSet.remove(id);
            }
        }

        public abstract String getIdParam();
    }

    public static class SelectionSet
    extends HashSet<String> {
        private static final long serialVersionUID = 1L;
        private boolean invertSelection = false;

        public SelectionSet() {
        }

        public SelectionSet(int size) {
            super(size);
        }

        public boolean isInvertSelection() {
            return this.invertSelection;
        }

        public void setInvertSelection(boolean invertSelection) {
            if (this.invertSelection == invertSelection) {
                return;
            }
            this.invertSelection = invertSelection;
            this.clear();
        }

        @Override
        public boolean contains(Object item) {
            boolean exists = super.contains(item);
            return this.invertSelection ? !exists : exists;
        }
    }
}

