/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataType;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.jsf2.controls.InputControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextInputControl
extends InputControl {
    private static final Logger log = LoggerFactory.getLogger(TextInputControl.class);
    public static final String NAME = "text";
    public static final String FORMAT_UNIT = "unit:";
    public static final String FORMAT_UNIT_ATTRIBUTE = "format:unit";
    public static final String DATE_FORMAT = "date-format:";
    public static final String DATE_FORMAT_ATTRIBUTE = "format:date";
    private Class<? extends HtmlInputText> inputComponentClass;

    public TextInputControl(String name, Class<? extends HtmlInputText> inputComponentClass) {
        super(name);
        this.inputComponentClass = inputComponentClass;
    }

    public TextInputControl(String name) {
        this(name, HtmlInputText.class);
    }

    public TextInputControl() {
        this(NAME, HtmlInputText.class);
    }

    @Override
    protected void createInputComponents(UIComponent parent, InputControl.InputInfo ii, FacesContext context, List<UIComponent> compList) {
        HtmlInputText input;
        try {
            input = this.inputComponentClass.newInstance();
        }
        catch (InstantiationException e1) {
            throw new InternalException((Throwable)e1);
        }
        catch (IllegalAccessException e2) {
            throw new InternalException((Throwable)e2);
        }
        this.copyAttributes(parent, ii, (UIInput)input);
        int maxLength = 0;
        DataType type = ii.getColumn().getDataType();
        switch (type) {
            case CHAR: 
            case TEXT: {
                maxLength = (int)Math.round(ii.getColumn().getSize());
                break;
            }
            case DECIMAL: {
                maxLength = (int)Math.round(ii.getColumn().getSize()) + 1;
                break;
            }
            default: {
                maxLength = 0;
            }
        }
        if (maxLength > 0) {
            input.setMaxlength(maxLength);
        }
        input.setDisabled(ii.isDisabled());
        this.setInputValue((UIInput)input, ii);
        compList.add((UIComponent)input);
    }

    @Override
    protected String formatValue(Object value, InputControl.ValueInfo vi, boolean hasError) {
        Options options = vi.getOptions();
        if (options != null && !options.isEmpty()) {
            String text = options.get(value);
            if (text != null) {
                return vi.getText(text);
            }
            log.error("The element '" + String.valueOf(value) + "' is not part of the supplied option list.");
        }
        if (value == null) {
            Object nullValue = this.getFormatOption(vi, "null:", "format:null");
            if (nullValue != null) {
                return this.formatValue(nullValue, vi, false);
            }
            return "";
        }
        Column column = vi.getColumn();
        DataType dataType = this.getValueType(value, column != null ? column.getDataType() : DataType.UNKNOWN);
        if (dataType == DataType.TEXT || dataType == DataType.UNKNOWN) {
            String s = String.valueOf(value);
            if (this.hasFormatOption(vi, "noencode")) {
                return s;
            }
            return this.escapeHTML(s);
        }
        if (dataType == DataType.INTEGER || dataType == DataType.AUTOINC) {
            NumberFormat nf = NumberFormat.getIntegerInstance(vi.getLocale());
            nf.setGroupingUsed(false);
            return nf.format(value);
        }
        if (dataType == DataType.DECIMAL || dataType == DataType.FLOAT) {
            NumberFormat nf = this.getNumberFormat(dataType, vi.getLocale(), column);
            return nf.format(value);
        }
        if (dataType == DataType.DATE || dataType == DataType.DATETIME) {
            if (dataType == DataType.DATETIME && this.hasFormatOption(vi, "notime")) {
                dataType = DataType.DATE;
            }
            DateFormat df = this.getDateFormat(dataType, vi, column);
            return df.format(value);
        }
        return this.escapeHTML(String.valueOf(value));
    }

    protected String formatValue(InputControl.ValueInfo vi, boolean appendUnit) {
        String unit;
        String text = super.formatValue(vi);
        if (appendUnit && text != null && text.length() > 0 && (unit = this.getUnitString(vi)) != null) {
            text = text + " " + unit;
        }
        return text;
    }

    protected DataType getValueType(Object value, DataType desiredType) {
        if (value instanceof String) {
            return DataType.TEXT;
        }
        if (value instanceof Number) {
            if (desiredType == DataType.AUTOINC || desiredType == DataType.INTEGER || desiredType == DataType.FLOAT || desiredType == DataType.DECIMAL) {
                return desiredType;
            }
            if (value instanceof Integer || value instanceof Long || value instanceof Short) {
                return DataType.INTEGER;
            }
            if (value instanceof Float || value instanceof Double) {
                return DataType.FLOAT;
            }
            return DataType.DECIMAL;
        }
        if (value instanceof Date) {
            if (desiredType == DataType.DATETIME || desiredType == DataType.DATE) {
                return desiredType;
            }
            if (value instanceof Timestamp) {
                return DataType.DATETIME;
            }
            return DataType.DATE;
        }
        if (value instanceof Boolean) {
            return DataType.BOOL;
        }
        return DataType.UNKNOWN;
    }

    protected NumberFormat getNumberFormat(DataType dataType, Locale locale, Column column) {
        Object fractDigit;
        if (column == null) {
            return NumberFormat.getNumberInstance(locale);
        }
        String type = StringUtils.valueOf((Object)column.getAttribute("numberType"));
        NumberFormat nf = null;
        nf = type.equalsIgnoreCase("Integer") ? NumberFormat.getIntegerInstance(locale) : NumberFormat.getNumberInstance(locale);
        Object groupSep = column.getAttribute("numberGroupSeparator");
        if (groupSep != null) {
            nf.setGroupingUsed(ObjectUtils.getBoolean((Object)groupSep));
        }
        if ((fractDigit = column.getAttribute("numberFractionDigits")) != null) {
            int fractionDigits = ObjectUtils.getInteger((Object)fractDigit);
            nf.setMaximumFractionDigits(fractionDigits);
            nf.setMinimumFractionDigits(fractionDigits);
        }
        return nf;
    }

    protected DateFormat getDateFormat(DataType dataType, InputControl.ValueInfo vi, Column column) {
        int type = 2;
        String format = this.getFormatString(vi, DATE_FORMAT, DATE_FORMAT_ATTRIBUTE);
        if (format != null) {
            if (StringUtils.compareEqual((String)format, (String)"short", (boolean)true)) {
                type = 3;
            } else if (StringUtils.compareEqual((String)format, (String)"long", (boolean)true)) {
                type = 1;
            }
        }
        DateFormat df = dataType == DataType.DATE ? DateFormat.getDateInstance(type, vi.getLocale()) : DateFormat.getDateTimeInstance(type, type, vi.getLocale());
        return df;
    }

    private String getUnitString(InputControl.ValueInfo vi) {
        String numberType;
        String format = this.getFormatString(vi, FORMAT_UNIT, FORMAT_UNIT_ATTRIBUTE);
        if (format != null) {
            return format;
        }
        Column column = vi.getColumn();
        if (column != null && column.getDataType() == DataType.DECIMAL && (numberType = StringUtils.toString((Object)column.getAttribute("numberType"))) != null) {
            if (numberType.equalsIgnoreCase("Currency")) {
                String currencyCode = StringUtils.toString((Object)column.getAttribute("currencyCode"));
                if (currencyCode != null) {
                    Currency currency = Currency.getInstance(currencyCode);
                    return currency != null ? currency.getSymbol() : null;
                }
            } else if (numberType.equalsIgnoreCase("Percent")) {
                return "%";
            }
        }
        return null;
    }

    protected Object parseInteger(String s) {
        return Integer.parseInt(s);
    }

    protected Object parseDecimal(String s, NumberFormat nf) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) < 'A') continue;
            throw new NumberFormatException("Not a number: " + s);
        }
        try {
            return nf.parseObject(s);
        }
        catch (ParseException pe) {
            throw new NumberFormatException("Not a number: " + s + " Exception: " + pe.toString());
        }
    }

    protected Object parseDate(String s, DateFormat df) {
        try {
            df.setLenient(true);
            return df.parseObject(s);
        }
        catch (ParseException pe) {
            throw new RuntimeException("Invalid date format: " + s, pe);
        }
    }
}

