/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.context.FacesContext;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.jsf2.controls.InputControl;

public class TextAreaInputControl
extends InputControl {
    public static final String NAME = "textarea";
    public static final String FORMAT_COLS = "cols:";
    public static final String FORMAT_COLS_ATTRIBUTE = "format:cols";
    public static final String FORMAT_ROWS = "rows:";
    public static final String FORMAT_ROWS_ATTRIBUTE = "format:rows";
    private Class<? extends HtmlInputTextarea> inputComponentClass;

    public TextAreaInputControl(Class<? extends HtmlInputTextarea> inputComponentClass) {
        super(NAME);
        this.inputComponentClass = inputComponentClass;
    }

    public TextAreaInputControl() {
        this(HtmlInputTextarea.class);
    }

    @Override
    protected void createInputComponents(UIComponent parent, InputControl.InputInfo ii, FacesContext context, List<UIComponent> compList) {
        int rows;
        HtmlInputTextarea input;
        try {
            input = this.inputComponentClass.newInstance();
        }
        catch (InstantiationException e1) {
            throw new InternalException((Throwable)e1);
        }
        catch (IllegalAccessException e2) {
            throw new InternalException((Throwable)e2);
        }
        this.copyAttributes(parent, ii, (UIInput)input);
        int cols = this.getFormatInteger(ii, FORMAT_COLS, FORMAT_COLS_ATTRIBUTE);
        if (cols > 0) {
            input.setCols(cols);
        }
        if ((rows = this.getFormatInteger(ii, FORMAT_ROWS, FORMAT_ROWS_ATTRIBUTE)) > 0) {
            input.setRows(rows);
        }
        input.setDisabled(ii.isDisabled());
        this.setInputValue((UIInput)input, ii);
        compList.add((UIComponent)input);
    }
}

