/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItem;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.Options;
import org.apache.empire.data.Column;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.jsf2.controls.InputControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectInputControl
extends InputControl {
    private static final Logger log = LoggerFactory.getLogger(SelectInputControl.class);
    public static final String COLATTR_ABBR_OPTIONS = "ABBR_OPTIONS";
    public static final String NAME = "select";
    private Class<? extends HtmlSelectOneMenu> inputComponentClass;

    public SelectInputControl(Class<? extends HtmlSelectOneMenu> inputComponentClass) {
        super(NAME);
        this.inputComponentClass = inputComponentClass;
    }

    public SelectInputControl() {
        this(HtmlSelectOneMenu.class);
    }

    public HtmlSelectOneMenu createMenuComponent(UIComponent parent) {
        try {
            return this.inputComponentClass.newInstance();
        }
        catch (InstantiationException e1) {
            throw new InternalException((Throwable)e1);
        }
        catch (IllegalAccessException e2) {
            throw new InternalException((Throwable)e2);
        }
    }

    @Override
    protected void createInputComponents(UIComponent parent, InputControl.InputInfo ii, FacesContext context, List<UIComponent> compList) {
        HtmlSelectOneMenu input;
        try {
            input = this.inputComponentClass.newInstance();
        }
        catch (InstantiationException e1) {
            throw new InternalException((Throwable)e1);
        }
        catch (IllegalAccessException e2) {
            throw new InternalException((Throwable)e2);
        }
        this.copyAttributes(parent, ii, (UIInput)input);
        Options options = ii.getOptions();
        if (!ii.isRequired()) {
            options = new Options(options);
            this.addSelectItem((UIComponent)input, ii, new OptionEntry((Object)"", this.getNullText(ii)));
        }
        if (options != null && options.size() > 0) {
            for (OptionEntry e : options) {
                this.addSelectItem((UIComponent)input, ii, e);
            }
        }
        input.setDisabled(ii.isDisabled());
        this.setInputValue((UIInput)input, ii);
        compList.add((UIComponent)input);
    }

    private String getNullText(InputControl.InputInfo ii) {
        String nullText = this.getFormatString(ii, "null:", "format:null");
        return nullText != null ? ii.getText(nullText) : "";
    }

    private void addSelectItem(UIComponent input, InputControl.InputInfo ii, OptionEntry e) {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)e.getValueString());
        String text = e.getText();
        text = ii.getText(text);
        selectItem.setItemLabel(text);
        input.getChildren().add(selectItem);
    }

    @Override
    protected String formatValue(Object value, InputControl.ValueInfo vi, boolean hasError) {
        Object attrValue;
        Column column;
        if (vi.getOptions() == null) {
            log.warn("Select field {} has no Option list attached!", (Object)vi.getColumn().getName());
            return super.formatValue(value, vi, hasError);
        }
        if (this.hasFormatOption(vi, "short") && (column = vi.getColumn()) != null && (attrValue = column.getAttribute(COLATTR_ABBR_OPTIONS)) instanceof Options) {
            String text = ((Options)attrValue).get(value);
            if (text != null) {
                return vi.getText(text);
            }
            log.error("The element '" + String.valueOf(value) + "' is not part of the supplied option list.");
        }
        return super.formatValue(value, vi, hasError);
    }
}

