/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InputControl {
    private static final Logger log = LoggerFactory.getLogger(InputControl.class);
    public static final String NUMBER_TYPE_ATTRIBUTE = "numberType";
    public static final String NUMBER_GROUPSEP_ATTRIBUTE = "numberGroupSeparator";
    public static final String NUMBER_FRACTION_DIGITS = "numberFractionDigits";
    public static final String MINVALUE_ATTRIBUTE = "minValue";
    public static final String MAXVALUE_ATTRIBUTE = "maxValue";
    public static final String CURRENCY_CODE_ATTRIBUTE = "currencyCode";
    public static final String FORMAT_NULL = "null:";
    public static final String FORMAT_NULL_ATTRIBUTE = "format:null";
    private String name;

    public InputControl() {
        log.info("InputControl of class {} created.", (Object)this.getClass().getName());
    }

    protected InputControl(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public void renderValue(ValueInfo vi, ResponseWriter writer) throws IOException {
        String text = this.formatValue(vi);
        writer.append((CharSequence)(StringUtils.isEmpty((String)text) ? "&nbsp;" : text));
    }

    public void renderInput(UIComponent comp, InputInfo ii, FacesContext context, boolean encode) throws IOException {
        int count = comp.getChildCount();
        if (count < 1) {
            this.createInputComponents(comp, ii, context, comp.getChildren());
        }
        if (!encode) {
            return;
        }
        for (UIComponent child : comp.getChildren()) {
            child.encodeAll(context);
        }
    }

    public Object getInputValue(UIComponent comp, InputInfo ii, boolean submitted) {
        UIInput input = this.getInputComponent(comp);
        if (input == null) {
            throw new ObjectNotValidException((Object)this);
        }
        return submitted ? input.getSubmittedValue() : input.getValue();
    }

    protected void setInputValue(UIInput input, InputInfo ii) {
        Object value = ii.getValue(false);
        if (value instanceof ValueExpression) {
            input.setLocalValueSet(false);
            input.setValueExpression("value", (ValueExpression)value);
        } else {
            input.setValue(value);
        }
    }

    protected abstract void createInputComponents(UIComponent var1, InputInfo var2, FacesContext var3, List<UIComponent> var4);

    protected UIInput getInputComponent(UIComponent parent) {
        int count = parent.getChildCount();
        if (count != 1) {
            return null;
        }
        UIComponent inp = (UIComponent)parent.getChildren().get(0);
        if (!(inp instanceof UIInput)) {
            throw new UnexpectedReturnValueException((Object)inp, "comp.getChildren().get(0)");
        }
        return (UIInput)inp;
    }

    protected void copyAttributes(UIComponent parent, InputInfo ii, UIInput input, String additonalStyle) {
        String inputId = ii.getInputId();
        if (StringUtils.isNotEmpty((String)inputId)) {
            input.getAttributes().put("id", inputId);
        }
        String styleClass = ii.getStyleClass(additonalStyle);
        input.getAttributes().put("styleClass", styleClass);
        this.copyAttribute(parent, input, "style");
        this.copyAttribute(parent, input, "tabindex");
        this.copyAttribute(parent, input, "onchange");
    }

    protected final void copyAttributes(UIComponent parent, InputInfo ii, UIInput input) {
        this.copyAttributes(parent, ii, input, null);
    }

    protected void copyAttribute(UIComponent parent, UIInput input, String name) {
        Object value = parent.getAttributes().get(name);
        if (value != null) {
            input.getAttributes().put(name, value);
        }
    }

    protected String formatValue(Object value, ValueInfo vi, boolean hasError) {
        Options options = vi.getOptions();
        if (options != null && !options.isEmpty() && !this.hasFormatOption(vi, "nolookup")) {
            String text = options.get(value);
            if (text != null) {
                return vi.getText(text);
            }
            log.error("The element '" + String.valueOf(value) + "' is not part of the supplied option list.");
        }
        if (value == null) {
            value = this.getFormatOption(vi, FORMAT_NULL, FORMAT_NULL_ATTRIBUTE);
        }
        String s = StringUtils.valueOf((Object)value);
        if (this.hasFormatOption(vi, "noencode")) {
            return s;
        }
        return this.escapeHTML(s);
    }

    protected final String formatValue(ValueInfo vi) {
        boolean hasError = false;
        return this.formatValue(vi.getValue(true), vi, hasError);
    }

    protected String escapeHTML(String text) {
        return text;
    }

    protected boolean hasFormatOption(ValueInfo vi, String option) {
        String format = vi.getFormat();
        return format != null ? format.indexOf(option) >= 0 : false;
    }

    private String getFormatOption(ValueInfo vi, String option) {
        String format = vi.getFormat();
        if (format == null) {
            return null;
        }
        int beg = format.indexOf(option);
        if (beg < 0) {
            return null;
        }
        int end = format.indexOf(59, (beg += option.length()) + 1);
        if (end < beg) {
            return format.substring(beg);
        }
        return format.substring(beg, end);
    }

    protected Object getFormatOption(ValueInfo vi, String option, String columnAttributeName) {
        String format = this.getFormatOption(vi, option);
        return format != null ? format : vi.getColumn().getAttribute(columnAttributeName);
    }

    protected String getFormatString(ValueInfo vi, String option, String columnAttributeName) {
        return StringUtils.toString((Object)this.getFormatOption(vi, option, columnAttributeName));
    }

    protected int getFormatInteger(ValueInfo vi, String option, String columnAttributeName) {
        return ObjectUtils.getInteger((Object)this.getFormatOption(vi, option, columnAttributeName));
    }

    public static interface InputInfo
    extends ValueInfo {
        public void setValue(Object var1);

        public void validate(Object var1);

        public boolean isRequired();

        public boolean isDisabled();

        public String getInputId();

        public String getTabindex();

        public String getStyleClass(String var1);
    }

    public static interface ValueInfo {
        public Column getColumn();

        public Options getOptions();

        public Object getValue(boolean var1);

        public String getFormat();

        public Locale getLocale();

        public String getText(String var1);
    }
}

