/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItem;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.apache.empire.jsf2.controls.SelectInputControl;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectTag
extends UIInput
implements NamingContainer {
    private static final Logger log = LoggerFactory.getLogger(SelectTag.class);

    public SelectTag() {
        log.trace("component select created");
    }

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        UIInput inputComponent = null;
        if (this.getChildCount() > 0) {
            inputComponent = this.getInputComponent();
        }
        if (inputComponent == null) {
            inputComponent = this.createSelectOneMenu(FacesUtils.getTextResolver(context));
            this.getChildren().add(inputComponent);
        }
        inputComponent.encodeAll(context);
        super.encodeBegin(context);
    }

    public void updateModel(FacesContext context) {
        if (!this.isDisabled()) {
            Object value;
            UIInput inputComponent = this.getInputComponent();
            Object object = value = inputComponent == null ? "" : inputComponent.getValue();
            if (value == null) {
                value = "";
            }
            this.setValue(value);
        }
        super.updateModel(context);
    }

    public void validate(FacesContext context) {
        UIInput inputComponent = this.getInputComponent();
        if (inputComponent == null) {
            return;
        }
        if (!inputComponent.isValid() || this.isDisabled()) {
            return;
        }
        super.validate(context);
    }

    private UIInput getInputComponent() {
        if (this.getChildren().size() == 0) {
            return null;
        }
        return (UIInput)this.getChildren().get(0);
    }

    private Options getOptionList() {
        Object options = this.getAttributes().get("options");
        if (!(options instanceof Options)) {
            return new Options();
        }
        return (Options)options;
    }

    private boolean isAllowNull() {
        Object allowNull = this.getAttributes().get("allowNull");
        return ObjectUtils.getBoolean(allowNull);
    }

    private String getNullText() {
        Object nullText = this.getAttributes().get("nullText");
        return StringUtils.toString(nullText, (String)"");
    }

    private boolean isDisabled() {
        Object disabled = this.getAttributes().get("disabled");
        return ObjectUtils.getBoolean(disabled);
    }

    private UIInput createSelectOneMenu(TextResolver textResolver) {
        SelectInputControl control = (SelectInputControl)InputControlManager.getControl("select");
        HtmlSelectOneMenu input = control.createMenuComponent((UIComponent)this);
        String userStyle = StringUtils.toString(this.getAttributes().get("styleClass"));
        String cssStyle = TagEncodingHelper.getTagStyleClass("eSelect", null, null, userStyle);
        input.setStyleClass(cssStyle);
        this.copyAttributes(input);
        Options options = this.getOptionList();
        if (this.isAllowNull()) {
            options = new Options(options);
            this.addSelectItem((UIComponent)input, textResolver, new OptionEntry((Object)"", this.getNullText()));
        }
        for (OptionEntry e : options) {
            this.addSelectItem((UIComponent)input, textResolver, e);
        }
        if (this.isDisabled()) {
            input.setDisabled(true);
        }
        input.setValue(this.getValue());
        return input;
    }

    private void copyAttributes(HtmlSelectOneMenu input) {
        Map attr = this.getAttributes();
        Object value = attr.get("style");
        if (value != null) {
            input.setStyle(StringUtils.toString(value));
        }
        if ((value = attr.get("tabindex")) != null) {
            input.setTabindex(StringUtils.toString(value));
        }
        if ((value = attr.get("onchange")) != null) {
            input.setOnchange(StringUtils.toString(value));
        }
    }

    private void addSelectItem(UIComponent input, TextResolver textResolver, OptionEntry e) {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)e.getValueString());
        String text = e.getText();
        text = textResolver.resolveText(text);
        selectItem.setItemLabel(text);
        input.getChildren().add(selectItem);
    }
}

