/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.StringUtils;

public class MenuListTag
extends UIOutput
implements NamingContainer {
    private String currentId = null;
    private String currentClass = null;
    private String enabledClass = null;
    private String disabledClass = null;
    private String expandedClass = null;
    private String defaultItemClass = null;
    private int level = 0;

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        Map map = this.getAttributes();
        this.initMenuAttributes(map);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("ul", (UIComponent)this);
        this.writeAttribute(writer, map, "styleClass", "class");
        this.writeAttribute(writer, map, "style");
    }

    public void encodeEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("ul");
        super.encodeEnd(context);
    }

    private void initMenuAttributes(Map<String, Object> map) {
        this.currentId = StringUtils.toString((Object)map.get("currentId"));
        this.currentClass = StringUtils.toString((Object)map.get("currentClass"));
        this.enabledClass = StringUtils.toString((Object)map.get("enabledClass"));
        this.disabledClass = StringUtils.toString((Object)map.get("disabledClass"));
        this.expandedClass = StringUtils.toString((Object)map.get("expandedClass"));
        this.defaultItemClass = StringUtils.toString((Object)map.get("defaultItemClass"));
        MenuListTag parent = this.getParentMenu();
        if (parent == null) {
            return;
        }
        if (this.currentId == null) {
            this.currentId = parent.getCurrentId();
        }
        if (this.currentClass == null) {
            this.currentClass = parent.getCurrentClass();
        }
        if (this.enabledClass == null) {
            this.enabledClass = parent.getEnabledClass();
        }
        if (this.disabledClass == null) {
            this.disabledClass = parent.getDisabledClass();
        }
        if (this.expandedClass == null) {
            this.expandedClass = parent.getExpandedClass();
        }
        if (this.defaultItemClass == null) {
            this.defaultItemClass = parent.defaultItemClass;
        }
        this.level = parent.level + 1;
    }

    protected MenuListTag getParentMenu() {
        MenuListTag parent = this;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof MenuListTag)) continue;
            return parent;
        }
        return null;
    }

    public String getCurrentId() {
        return this.currentId;
    }

    public String getCurrentClass() {
        return this.currentClass;
    }

    public String getEnabledClass() {
        return this.enabledClass;
    }

    public String getDisabledClass() {
        return this.disabledClass;
    }

    public String getExpandedClass() {
        return this.expandedClass;
    }

    public int getLevel() {
        return this.level;
    }

    public String getItemStyleClass() {
        if (this.defaultItemClass != null && this.defaultItemClass.indexOf("{}") >= 0) {
            return StringUtils.replace((String)this.defaultItemClass, (String)"{}", (String)String.valueOf(this.level));
        }
        return this.defaultItemClass;
    }

    public void setCurrentId(String currentId) {
        this.currentId = currentId;
    }

    public void setCurrentClass(String currentClass) {
        this.currentClass = currentClass;
    }

    public void setEnabledClass(String enabledClass) {
        this.enabledClass = enabledClass;
    }

    public void setDisabledClass(String disabledClass) {
        this.disabledClass = disabledClass;
    }

    public void setExpandedClass(String expandedClass) {
        this.expandedClass = expandedClass;
    }

    protected void writeAttribute(ResponseWriter writer, Map<String, Object> map, String attribute, String targetName) throws IOException {
        Object value = map.get(attribute);
        if (value != null) {
            writer.writeAttribute(targetName, value, null);
        }
    }

    protected void writeAttribute(ResponseWriter writer, Map<String, Object> map, String attribute) throws IOException {
        this.writeAttribute(writer, map, attribute, attribute);
    }
}

