/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlOutcomeTargetLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.jsf2.components.LinkTag;
import org.apache.empire.jsf2.components.MenuListTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuItemTag
extends LinkTag {
    private static final Logger log = LoggerFactory.getLogger(MenuItemTag.class);
    private static int renderCount = 1;
    private MenuListTag parentMenu = null;
    private String menuId;

    @Override
    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        this.parentMenu = this.getParentMenu();
        this.menuId = StringUtils.toString(this.getAttributes().get("menuId"));
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("li", (UIComponent)this);
        writer.writeAttribute("id", (Object)this.getClientId(context), null);
        writer.writeAttribute("class", (Object)this.getStyleClass(), null);
        writer.writeAttribute("count", (Object)String.valueOf(renderCount++), null);
        super.encodeBegin(context);
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
        if (this.isExpanded()) {
            UIComponent c = (UIComponent)this.getChildren().get(0);
            if (c instanceof HtmlOutcomeTargetLink) {
                if (c.isRendered()) {
                    log.warn("Unexpected rendering of output link. Rendering is ignored.");
                    c.setRendered(false);
                }
            } else {
                log.warn("Unexpected child element as first child of MenuItemTag!");
            }
            super.encodeChildren(context);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        super.encodeEnd(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("li");
    }

    @Override
    protected String getLinkStyleClass() {
        return null;
    }

    protected MenuListTag getParentMenu() {
        MenuItemTag parent = this;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof MenuListTag)) continue;
            return (MenuListTag)((Object)parent);
        }
        return null;
    }

    private boolean isCurrent() {
        if (this.menuId == null || this.parentMenu == null || this.parentMenu.getCurrentId() == null) {
            return false;
        }
        return this.menuId.equals(this.parentMenu.getCurrentId());
    }

    private boolean isDisabled() {
        Object value = this.getAttributes().get("disabled");
        if (value != null) {
            return ObjectUtils.getBoolean(value);
        }
        return false;
    }

    private boolean isExpanded() {
        Object value = this.getAttributes().get("expanded");
        boolean auto = false;
        if (value != null) {
            auto = "auto".equals(value);
            if (!auto) {
                return ObjectUtils.getBoolean(value);
            }
            if (this.isCurrent()) {
                return true;
            }
        }
        if (this.menuId == null || this.parentMenu == null || this.parentMenu.getCurrentId() == null) {
            return auto;
        }
        String currentId = this.parentMenu.getCurrentId();
        return currentId.startsWith(this.menuId + ".");
    }

    public boolean isRendered() {
        Object value = this.getAttributes().get("currentOnly");
        boolean currentOnly = false;
        if (value != null) {
            currentOnly = ObjectUtils.getBoolean(value);
        }
        if (currentOnly && this.menuId != null && this.parentMenu != null && this.parentMenu.getCurrentId() != null) {
            return this.isCurrent();
        }
        return super.isRendered();
    }

    private String getStyleClass() {
        String styleClass = StringUtils.toString(this.getAttributes().get("styleClass"));
        String menuClass = null;
        if (this.parentMenu != null) {
            menuClass = this.isCurrent() ? this.parentMenu.getCurrentClass() : (this.isExpanded() ? this.parentMenu.getExpandedClass() : (this.isDisabled() ? this.parentMenu.getDisabledClass() : this.parentMenu.getEnabledClass()));
            if (StringUtils.isEmpty((String)styleClass)) {
                styleClass = this.parentMenu.getItemStyleClass();
            }
        }
        if (menuClass == null) {
            return styleClass;
        }
        if (StringUtils.isEmpty((String)styleClass)) {
            return menuClass;
        }
        return styleClass + " " + menuClass;
    }
}

