/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlOutcomeTargetLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.utils.StringResponseWriter;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkTag
extends UIOutput
implements NamingContainer {
    private static final Logger log = LoggerFactory.getLogger(LinkTag.class);
    private final TagEncodingHelper helper = new TagEncodingHelper(this, "eLink");

    public LinkTag() {
        log.trace("component link created");
    }

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.helper.encodeBegin();
        if (this.isLinkDisabled()) {
            ResponseWriter writer = context.getResponseWriter();
            String tag = this.writeStartElement(writer);
            writer.write(StringUtils.toString((Object)this.getLinkValue(this.helper.hasColumn()), (String)""));
            writer.endElement(tag);
        } else {
            HtmlOutcomeTargetLink linkComponent = null;
            if (this.getChildCount() > 0) {
                UIComponent c = (UIComponent)this.getChildren().get(0);
                if (c instanceof HtmlOutcomeTargetLink) {
                    linkComponent = (HtmlOutcomeTargetLink)c;
                } else {
                    log.info("TODO: handle Child nodes!");
                }
            }
            if (linkComponent == null) {
                linkComponent = new HtmlOutcomeTargetLink();
                this.getChildren().add(linkComponent);
            }
            this.setLinkProperties(linkComponent);
            this.addOrSetParam(linkComponent, "idparam", "id");
            linkComponent.setRendered(true);
            linkComponent.encodeAll(context);
            linkComponent.setRendered(false);
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (!this.isLinkDisabled()) {
            super.encodeChildren(context);
        }
    }

    protected String getLinkStyleClass() {
        return StringUtils.toString(this.getAttributes().get("styleClass"));
    }

    private boolean isLinkDisabled() {
        Object v = this.getAttributes().get("disabled");
        if (v == null) {
            return false;
        }
        return ObjectUtils.getBoolean(v);
    }

    private Object getLinkValue(boolean hasColumn) {
        if (hasColumn) {
            InputControl control = this.helper.getInputControl();
            InputControl.ValueInfo vi = this.helper.getValueInfo(FacesContext.getCurrentInstance());
            StringResponseWriter srw = new StringResponseWriter();
            try {
                control.renderValue(vi, srw);
            }
            catch (IOException e) {
                log.error("Failed to render value for " + vi.getColumn().getName() + " error is:" + e.getMessage(), (Throwable)e);
            }
            return srw.toString();
        }
        Object value = this.getValue();
        return value;
    }

    private void setLinkProperties(HtmlOutcomeTargetLink link) {
        boolean hasColumn = this.helper.hasColumn();
        Object value = this.getLinkValue(hasColumn);
        link.setValue(value);
        DataType dataType = hasColumn ? this.helper.getColumn().getDataType() : DataType.UNKNOWN;
        link.setStyleClass(this.helper.getTagStyleClass(dataType, null, this.getLinkStyleClass()));
        Map attr = this.getAttributes();
        String outcome = StringUtils.toString(attr.get("page"));
        link.setOutcome(outcome);
        value = attr.get("style");
        if (value != null) {
            link.setStyle(StringUtils.toString((Object)value));
        }
        if ((value = attr.get("tabindex")) != null) {
            link.setTabindex(StringUtils.toString((Object)value));
        }
        if ((value = attr.get("onclick")) != null) {
            link.setOnclick(StringUtils.toString((Object)value));
        }
        link.setIncludeViewParams(false);
    }

    private void addOrSetParam(HtmlOutcomeTargetLink link, String attribute, String paramName) {
        String paramValue = StringUtils.toString(this.getAttributes().get(attribute));
        if (StringUtils.isEmpty((String)paramValue)) {
            return;
        }
        List l = link.getChildren();
        for (UIComponent c : l) {
            UIParameter p;
            if (!(c instanceof UIParameter) || !(p = (UIParameter)c).getName().equalsIgnoreCase(paramName)) continue;
            p.setValue((Object)paramValue);
            return;
        }
        UIParameter param = new UIParameter();
        param.setName(paramName);
        param.setValue((Object)paramValue);
        link.getChildren().add(param);
    }

    protected String writeStartElement(ResponseWriter writer) throws IOException {
        Map map = this.getAttributes();
        String tagName = StringUtils.coalesce((String)StringUtils.toString(map.get("tag")), (String)"span");
        String cssClass = this.helper.getTagStyleClass();
        Object style = map.get("style");
        Object title = map.get("title");
        writer.startElement(tagName, (UIComponent)this);
        this.helper.writeAttribute(writer, "class", cssClass);
        this.helper.writeAttribute(writer, "style", style);
        this.helper.writeAttribute(writer, "title", this.helper.hasColumn() ? this.helper.getValueTooltip(title) : title);
        return tagName;
    }
}

