/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelTag
extends UIOutput {
    private static final Logger log = LoggerFactory.getLogger(LabelTag.class);
    private final TagEncodingHelper helper = new TagEncodingHelper(this, "eLabel");

    public LabelTag() {
        log.trace("component LabelTag created");
    }

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        HtmlOutputLabel labelComponent = null;
        if (this.getChildCount() > 0) {
            labelComponent = (HtmlOutputLabel)this.getChildren().get(0);
        }
        if (labelComponent == null) {
            String forInput = this.helper.getTagAttribute("for");
            String styleClass = this.helper.getTagStyleClass(DataType.UNKNOWN);
            String style = this.helper.getTagAttribute("style");
            labelComponent = this.helper.createLabelComponent(context, forInput, styleClass, style, this.getColon());
            this.getChildren().add(labelComponent);
        }
        labelComponent.encodeAll(context);
    }

    protected boolean getColon() {
        Object colon = this.getAttributes().get("colon");
        if (colon != null) {
            return ObjectUtils.getBoolean(colon);
        }
        return true;
    }
}

