/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.data.Column;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputTag
extends UIInput
implements NamingContainer {
    private static final Logger log = LoggerFactory.getLogger(InputTag.class);
    private static final String readOnlyState = "readOnlyState";
    private final TagEncodingHelper helper = new TagEncodingHelper((UIOutput)this, "eInput");
    private InputControl control = null;
    private InputControl.InputInfo inpInfo = null;

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    private void saveState() {
        this.getStateHelper().put((Serializable)((Object)readOnlyState), (Object)(this.inpInfo == null ? 1 : 0));
    }

    private boolean initState(FacesContext context) {
        Boolean ros = (Boolean)this.getStateHelper().get((Serializable)((Object)readOnlyState));
        if (ros != null && ros.booleanValue()) {
            return false;
        }
        this.control = this.helper.getInputControl();
        this.inpInfo = this.helper.getInputInfo(context);
        return this.control != null && this.inpInfo != null;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.helper.encodeBegin();
        this.control = this.helper.getInputControl();
        if (this.helper.isRecordReadOnly()) {
            InputControl.ValueInfo valInfo = this.helper.getValueInfo(context);
            ResponseWriter writer = context.getResponseWriter();
            String tag = this.writeStartElement(valInfo, writer);
            this.control.renderValue(valInfo, writer);
            writer.endElement(tag);
        } else {
            this.inpInfo = this.helper.getInputInfo(context);
            this.control.renderInput((UIComponent)this, this.inpInfo, context, true);
        }
        this.saveState();
    }

    public Object getValue() {
        if (this.helper.getRecord() != null) {
            return this.helper.getDataValue(true);
        }
        Object value = super.getValue();
        return value;
    }

    public Object getSubmittedValue() {
        if (this.control == null || this.inpInfo == null) {
            return null;
        }
        return this.control.getInputValue((UIComponent)this, this.inpInfo, true);
    }

    public void validateValue(FacesContext context, Object value) {
        if (this.inpInfo == null) {
            return;
        }
        this.inpInfo.validate(value);
        this.setValid(true);
        super.validateValue(context, value);
    }

    public void validate(FacesContext context) {
        if (!this.initState(context)) {
            return;
        }
        if (this.inpInfo.isDisabled()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating input for {}.", (Object)this.inpInfo.getColumn().getName());
        }
        try {
            super.validate(context);
        }
        catch (Exception e) {
            this.helper.addErrorMessage(context, e);
            this.setValid(false);
        }
    }

    public void updateModel(FacesContext context) {
        if (!this.initState(context)) {
            return;
        }
        if (this.inpInfo.isDisabled()) {
            return;
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        log.debug("Updating model input for {}.", (Object)this.inpInfo.getColumn().getName());
        this.inpInfo.setValue(this.getLocalValue());
        this.setValue(null);
        this.setLocalValueSet(false);
    }

    public Column getInputColumn() {
        return this.helper.getColumn();
    }

    public boolean isInputReadOnly() {
        return this.helper.isRecordReadOnly();
    }

    public boolean isInputRequired() {
        return this.helper.isValueRequired();
    }

    protected String writeStartElement(InputControl.ValueInfo vi, ResponseWriter writer) throws IOException {
        String tagName = "span";
        String className = this.helper.getTagStyleClass("eInpDis");
        Map map = this.getAttributes();
        Object style = map.get("style");
        Object title = map.get("title");
        writer.startElement(tagName, (UIComponent)this);
        this.helper.writeAttribute(writer, "class", className);
        this.helper.writeAttribute(writer, "style", style);
        this.helper.writeAttribute(writer, "title", this.helper.getValueTooltip(title));
        return tagName;
    }
}

