/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.io.Serializable;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlTag
extends UIInput
implements NamingContainer {
    public static String DEFAULT_CONTROL_SEPARATOR_TAG = "td";
    public static String DEFAULT_LABEL_SEPARATOR_CLASS = "eCtlLabel";
    public static String DEFAULT_INPUT_SEPARATOR_CLASS = "eCtlInput";
    private static final Logger log = LoggerFactory.getLogger(ControlTag.class);
    private static final String readOnlyState = "readOnlyState";
    private static final boolean encodeLabel = true;
    protected final TagEncodingHelper helper = new TagEncodingHelper((UIOutput)this, "eInput");
    protected InputControl control = null;
    protected InputControl.InputInfo inpInfo = null;

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    private void saveState() {
        this.getStateHelper().put((Serializable)((Object)readOnlyState), (Object)(this.inpInfo == null ? 1 : 0));
    }

    private boolean initState(FacesContext context) {
        Boolean ros = (Boolean)this.getStateHelper().get((Serializable)((Object)readOnlyState));
        if (ros != null && ros.booleanValue()) {
            return false;
        }
        this.control = this.helper.getInputControl();
        this.inpInfo = this.helper.getInputInfo(context);
        return this.control != null && this.inpInfo != null;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.helper.encodeBegin();
        this.control = this.helper.getInputControl();
        boolean isCustomInput = this.isCustomInput();
        ControlSeparatorComponent labelSepTag = null;
        if (this.getChildCount() > 0) {
            labelSepTag = (ControlSeparatorComponent)((Object)this.getChildren().get(0));
        }
        if (labelSepTag == null) {
            labelSepTag = new LabelSeparatorComponent();
            this.getChildren().add(labelSepTag);
        }
        labelSepTag.setRendered(true);
        this.encodeLabel(context, labelSepTag);
        if (isCustomInput) {
            labelSepTag.setRendered(false);
        }
        if (!isCustomInput) {
            ControlSeparatorComponent inputSepTag = null;
            if (this.getChildCount() > 1) {
                inputSepTag = (ControlSeparatorComponent)((Object)this.getChildren().get(1));
            }
            if (inputSepTag == null) {
                inputSepTag = new InputSeparatorComponent();
                this.getChildren().add(inputSepTag);
            }
            this.encodeInput(context, inputSepTag);
        }
        this.saveState();
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (this.isCustomInput()) {
            String tagName = this.helper.getTagAttribute("tag", DEFAULT_CONTROL_SEPARATOR_TAG);
            String inpClass = this.helper.getTagAttribute("inputClass", DEFAULT_INPUT_SEPARATOR_CLASS);
            String colSpan = this.helper.getTagAttribute("colspan");
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement(tagName, (UIComponent)this);
            if (StringUtils.isNotEmpty((String)inpClass)) {
                writer.writeAttribute("class", (Object)inpClass, null);
            }
            if (StringUtils.isNotEmpty((String)colSpan) && tagName.equalsIgnoreCase("td")) {
                writer.writeAttribute("colspan", (Object)colSpan, null);
            }
            super.encodeChildren(context);
            writer.endElement(tagName);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
    }

    private boolean isCustomInput() {
        Object custom = this.getAttributes().get("custom");
        if (custom != null) {
            return ObjectUtils.getBoolean(custom);
        }
        return false;
    }

    private void encodeLabel(FacesContext context, UIComponentBase parent) throws IOException {
        HtmlOutputLabel labelComponent = null;
        if (parent.getChildCount() > 0) {
            labelComponent = (HtmlOutputLabel)parent.getChildren().get(0);
        }
        if (labelComponent == null) {
            String forInput = this.isCustomInput() ? this.helper.getTagAttribute("for") : "*";
            labelComponent = this.helper.createLabelComponent(context, forInput, "eLabel", null, true);
            parent.getChildren().add(0, labelComponent);
        }
        parent.encodeAll(context);
    }

    private void encodeInput(FacesContext context, UIComponentBase parent) throws IOException {
        if (this.helper.isRecordReadOnly()) {
            ValueOutputComponent valueComp = null;
            if (parent.getChildCount() > 0) {
                valueComp = (ValueOutputComponent)((Object)parent.getChildren().get(0));
            }
            if (valueComp == null) {
                valueComp = new ValueOutputComponent();
                parent.getChildren().add(valueComp);
            }
        } else {
            this.inpInfo = this.helper.getInputInfo(context);
            this.control.renderInput((UIComponent)parent, this.inpInfo, context, false);
        }
        parent.encodeAll(context);
    }

    public Object getValue() {
        if (this.helper.getRecord() != null) {
            return this.helper.getDataValue(true);
        }
        Object value = super.getValue();
        return value;
    }

    public Object getSubmittedValue() {
        if (this.control == null || this.inpInfo == null) {
            return null;
        }
        if (this.getChildCount() <= 1) {
            return null;
        }
        ControlSeparatorComponent inputSepTag = (ControlSeparatorComponent)((Object)this.getChildren().get(1));
        return this.control.getInputValue((UIComponent)inputSepTag, this.inpInfo, true);
    }

    public void validateValue(FacesContext context, Object value) {
        if (this.inpInfo == null) {
            return;
        }
        this.inpInfo.validate(value);
        this.setValid(true);
        super.validateValue(context, value);
    }

    public void validate(FacesContext context) {
        if (!this.initState(context)) {
            return;
        }
        if (this.inpInfo.isDisabled()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating input for {}.", (Object)this.inpInfo.getColumn().getName());
        }
        try {
            super.validate(context);
        }
        catch (Exception e) {
            this.helper.addErrorMessage(context, e);
            this.setValid(false);
        }
    }

    public void updateModel(FacesContext context) {
        if (!this.initState(context)) {
            return;
        }
        if (this.inpInfo.isDisabled()) {
            return;
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        log.debug("Updating model input for {}.", (Object)this.inpInfo.getColumn().getName());
        this.inpInfo.setValue(this.getLocalValue());
        this.setValue(null);
        this.setLocalValueSet(false);
    }

    public Column getInputColumn() {
        return this.helper.getColumn();
    }

    public boolean isInputReadOnly() {
        return this.helper.isRecordReadOnly();
    }

    public boolean isInputRequired() {
        return this.helper.isValueRequired();
    }

    public static class ValueOutputComponent
    extends UIComponentBase {
        private final String tagName = "span";

        public String getFamily() {
            return "javax.faces.NamingContainer";
        }

        public void encodeBegin(FacesContext context) throws IOException {
            super.encodeBegin(context);
            UIComponent parent = this.getParent();
            if (!(parent instanceof ControlTag)) {
                parent = parent.getParent();
            }
            if (!(parent instanceof ControlTag)) {
                parent = parent.getParent();
            }
            if (!(parent instanceof ControlTag)) {
                log.error("Invalid parent component for " + ((Object)((Object)this)).getClass().getName());
                return;
            }
            ControlTag controlTag = (ControlTag)parent;
            TagEncodingHelper helper = controlTag.helper;
            InputControl control = helper.getInputControl();
            InputControl.ValueInfo valInfo = helper.getValueInfo(context);
            String styleClass = helper.getTagStyleClass("eInpDis");
            String tooltip = helper.getValueTooltip(helper.getTagAttribute("title"));
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", (UIComponent)this);
            if (StringUtils.isNotEmpty((String)styleClass)) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            if (StringUtils.isNotEmpty((String)tooltip)) {
                writer.writeAttribute("title", (Object)tooltip, null);
            }
            control.renderValue(valInfo, writer);
            writer.endElement("span");
        }
    }

    public static class InputSeparatorComponent
    extends ControlSeparatorComponent {
        @Override
        protected void writeAttributes(ResponseWriter writer, TagEncodingHelper helper, String tagName) throws IOException {
            String colSpan;
            String styleClass = helper.getTagAttribute("inputClass", DEFAULT_INPUT_SEPARATOR_CLASS);
            if (StringUtils.isNotEmpty((String)styleClass)) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            if (StringUtils.isNotEmpty((String)(colSpan = helper.getTagAttribute("colspan"))) && tagName.equalsIgnoreCase("td")) {
                writer.writeAttribute("colspan", (Object)colSpan, null);
            }
        }
    }

    public static class LabelSeparatorComponent
    extends ControlSeparatorComponent {
        @Override
        protected void writeAttributes(ResponseWriter writer, TagEncodingHelper helper, String tagName) throws IOException {
            String styleClass = helper.getTagAttribute("labelClass", DEFAULT_LABEL_SEPARATOR_CLASS);
            if (StringUtils.isNotEmpty((String)styleClass)) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
        }
    }

    public static abstract class ControlSeparatorComponent
    extends UIComponentBase {
        private ControlTag control = null;

        public String getFamily() {
            return "javax.faces.NamingContainer";
        }

        public void encodeBegin(FacesContext context) throws IOException {
            super.encodeBegin(context);
            UIComponent parent = this.getParent();
            if (!(parent instanceof ControlTag)) {
                parent = parent.getParent();
            }
            if (!(parent instanceof ControlTag)) {
                log.error("Invalid parent component for " + ((Object)((Object)this)).getClass().getName());
                return;
            }
            this.control = (ControlTag)parent;
        }

        protected abstract void writeAttributes(ResponseWriter var1, TagEncodingHelper var2, String var3) throws IOException;

        public boolean getRendersChildren() {
            return true;
        }

        public void encodeChildren(FacesContext context) throws IOException {
            if (this.control != null) {
                TagEncodingHelper helper = this.control.helper;
                String tagName = helper.getTagAttribute("tag", "td");
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement(tagName, (UIComponent)this);
                this.writeAttributes(writer, helper, tagName);
                super.encodeChildren(context);
                writer.endElement(tagName);
            }
        }
    }
}

