/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.empire.exceptions.EmpireException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextResolver {
    private static final Logger log = LoggerFactory.getLogger(TextResolver.class);
    public static String MSG_KEY_INDICATOR = "!";
    private final ResourceBundle resBundle;

    public TextResolver(ResourceBundle resBundle) {
        this.resBundle = resBundle;
    }

    public final ResourceBundle getResourceBundle() {
        return this.resBundle;
    }

    public final Locale getLocale() {
        return this.resBundle.getLocale();
    }

    public String resolveKey(String key) {
        try {
            String res = this.resBundle.getString(key);
            if (res == null) {
                throw new MissingResourceException("Message Key not found.", String.class.getSimpleName(), key);
            }
            return res;
        }
        catch (MissingResourceException e) {
            log.error("Message key missing '{}'.", (Object)key);
            return "[" + key + "]";
        }
        catch (Exception e) {
            log.error("Error resolving text: {}", (Throwable)e);
            return "[" + key + "]";
        }
    }

    public String resolveText(String text) {
        if (text != null && text.startsWith(MSG_KEY_INDICATOR)) {
            String key = text.substring(1);
            return this.resolveKey(key);
        }
        return text;
    }

    public String getExceptionMessage(Exception e) {
        if (e instanceof EmpireException) {
            String pattern;
            EmpireException ee = (EmpireException)e;
            String key = ee.getErrorType().getKey();
            if (this.resBundle.containsKey(key)) {
                pattern = this.resBundle.getString(key);
            } else {
                pattern = ee.getErrorType().getMessagePattern();
                log.error("Error resolving error messsage pattern: {}", (Object)key);
            }
            String[] params = ee.getErrorParams();
            Object[] values = null;
            if (params != null) {
                values = new Object[params.length];
                for (int i = 0; i < params.length; ++i) {
                    values[i] = this.resolveText(params[i]);
                }
            }
            return MessageFormat.format(pattern, values);
        }
        String key = "exception." + e.getClass().getName();
        if (this.resBundle.containsKey(key)) {
            return this.resBundle.getString(key);
        }
        return e.getLocalizedMessage();
    }
}

