/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.providers.iot;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.edgent.apps.iot.IotDevicePubSub;
import org.apache.edgent.apps.runtime.JobMonitorApp;
import org.apache.edgent.connectors.iot.IotDevice;
import org.apache.edgent.connectors.pubsub.service.ProviderPubSub;
import org.apache.edgent.connectors.pubsub.service.PublishSubscribeService;
import org.apache.edgent.execution.DirectSubmitter;
import org.apache.edgent.execution.Job;
import org.apache.edgent.execution.services.ControlService;
import org.apache.edgent.execution.services.ServiceContainer;
import org.apache.edgent.function.BiConsumer;
import org.apache.edgent.function.Function;
import org.apache.edgent.providers.direct.DirectProvider;
import org.apache.edgent.providers.iot.IotProvider$$Lambda$1;
import org.apache.edgent.providers.iot.IotProvider$$Lambda$4;
import org.apache.edgent.providers.iot.IotProvider$$Lambda$5;
import org.apache.edgent.providers.iot.IotProvider$$Lambda$6;
import org.apache.edgent.providers.iot.IotProvider$$Lambda$7;
import org.apache.edgent.runtime.appservice.AppService;
import org.apache.edgent.runtime.jsoncontrol.JsonControlService;
import org.apache.edgent.topology.TStream;
import org.apache.edgent.topology.Topology;
import org.apache.edgent.topology.TopologyElement;
import org.apache.edgent.topology.TopologyProvider;
import org.apache.edgent.topology.mbeans.ApplicationServiceMXBean;
import org.apache.edgent.topology.services.ApplicationService;
import org.slf4j.LoggerFactory;

public class IotProvider
implements TopologyProvider,
DirectSubmitter<Topology, Job> {
    public static final String CONTROL_APP_NAME = "edgentIotCommandsToControl";
    private final String name;
    private final TopologyProvider provider;
    private final Function<Topology, IotDevice> iotDeviceCreator;
    private final DirectSubmitter<Topology, Job> submitter;
    private final List<String> systemApps = new ArrayList<String>();
    private final Map<String, JsonObject> autoSubmitApps = new HashMap<String, JsonObject>();
    private JsonControlService controlService = new JsonControlService();

    public IotProvider(Function<Topology, IotDevice> iotDeviceCreator) {
        this(null, new DirectProvider(), iotDeviceCreator);
    }

    public IotProvider(String name, Function<Topology, IotDevice> iotDeviceCreator) {
        this(name, new DirectProvider(), iotDeviceCreator);
    }

    public IotProvider(String name, DirectProvider provider, Function<Topology, IotDevice> iotDeviceCreator) {
        this(name, (TopologyProvider)provider, (DirectSubmitter<Topology, Job>)provider, iotDeviceCreator);
    }

    public IotProvider(String name, TopologyProvider provider, DirectSubmitter<Topology, Job> submitter, Function<Topology, IotDevice> iotDeviceCreator) {
        this.name = name;
        this.provider = provider;
        this.submitter = submitter;
        this.iotDeviceCreator = iotDeviceCreator;
        this.registerControlService();
        this.registerApplicationService();
        this.registerPublishSubscribeService();
        this.registerPreferencesService();
        this.createIotDeviceApp();
        this.createIotCommandToControlApp();
        this.createJobMonitorApp();
    }

    public String getName() {
        return this.name;
    }

    public ApplicationService getApplicationService() {
        return (ApplicationService)this.getServices().getService(ApplicationService.class);
    }

    public ServiceContainer getServices() {
        return this.submitter.getServices();
    }

    public final Topology newTopology() {
        return this.provider.newTopology();
    }

    public final Topology newTopology(String name) {
        return this.provider.newTopology(name);
    }

    public final Future<Job> submit(Topology topology) {
        return this.submitter.submit((Object)topology);
    }

    public final Future<Job> submit(Topology topology, JsonObject config) {
        return this.submitter.submit((Object)topology, config);
    }

    protected void registerControlService() {
        this.getServices().addService(ControlService.class, (Object)this.getControlService());
    }

    protected void registerApplicationService() {
        AppService.createAndRegister((TopologyProvider)this, (DirectSubmitter)this);
    }

    protected void registerPublishSubscribeService() {
        this.getServices().addService(PublishSubscribeService.class, (Object)new ProviderPubSub());
    }

    protected void registerPreferencesService() {
        if (this.getName() == null) {
            return;
        }
        Preferences providerNode = IotProvider.getPreferences(this.getName());
        this.getServices().addService(Preferences.class, (Object)providerNode);
        try {
            providerNode.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static Preferences getPreferences(String providerName) {
        Preferences classNode = Preferences.userNodeForPackage(IotProvider.class);
        Preferences providerNode = classNode.node(providerName);
        return providerNode;
    }

    protected JsonControlService getControlService() {
        return this.controlService;
    }

    protected void createIotDeviceApp() {
        this.getApplicationService().registerTopology("edgentIotDevicePubSub", IotProvider$$Lambda$1.lambdaFactory$(this));
        this.systemApps.add("edgentIotDevicePubSub");
    }

    protected void createJobMonitorApp() {
        this.getApplicationService().registerTopology("edgentJobMonitorApp", IotProvider$$Lambda$4.lambdaFactory$());
        this.systemApps.add("edgentJobMonitorApp");
    }

    protected void createIotCommandToControlApp() {
        this.registerTopology(CONTROL_APP_NAME, (BiConsumer<IotDevice, JsonObject>)IotProvider$$Lambda$5.lambdaFactory$(this));
        this.systemApps.add(CONTROL_APP_NAME);
    }

    public void start() throws Exception {
        ApplicationServiceMXBean bean = (ApplicationServiceMXBean)this.getControlService().getControl("appService", "edgent", ApplicationServiceMXBean.class);
        for (String string : this.systemApps) {
            bean.submit(string, null);
        }
        for (Map.Entry entry : this.autoSubmitApps.entrySet()) {
            this.submitApplication((String)entry.getKey(), (JsonObject)entry.getValue());
        }
    }

    protected IotDevice createMessageHubDevice(Topology topology) {
        return (IotDevice)this.iotDeviceCreator.apply((Object)topology);
    }

    public void registerTopology(String applicationName, BiConsumer<IotDevice, JsonObject> builder) {
        this.registerTopology(applicationName, builder, false, null);
    }

    public void registerTopology(String applicationName, BiConsumer<IotDevice, JsonObject> builder, boolean autoSubmit, JsonObject config) {
        this.getApplicationService().registerTopology(applicationName, IotProvider$$Lambda$6.lambdaFactory$(builder));
        if (autoSubmit) {
            this.autoSubmitApps.put(applicationName, config);
        }
    }

    private void submitApplication(String appName, JsonObject config) throws Exception {
        if (this.systemApps.contains(appName)) {
            throw new IllegalArgumentException("appName");
        }
        ApplicationServiceMXBean bean = (ApplicationServiceMXBean)this.getControlService().getControl("appService", "edgent", ApplicationServiceMXBean.class);
        bean.submit(appName, config == null ? null : config.toString());
    }

    static /* synthetic */ void lambda$registerTopology$ea7bdbc8$1(BiConsumer builder, Topology topology, JsonObject cfg) {
        builder.accept((Object)IotDevicePubSub.addIotDevice((TopologyElement)topology), (Object)cfg);
    }

    static /* synthetic */ void lambda$createIotCommandToControlApp$3e967447$1(IotProvider this_, IotDevice iotDevice, JsonObject config) {
        TStream controlCommands = iotDevice.commands(new String[]{"edgentControl"});
        controlCommands.sink(IotProvider$$Lambda$7.lambdaFactory$(this_));
    }

    static /* synthetic */ void lambda$null$9f4ce4e9$1(IotProvider this_, JsonObject cmd) {
        try {
            this_.getControlService().controlRequest(cmd.getAsJsonObject("payload"));
        }
        catch (Exception re) {
            LoggerFactory.getLogger(ControlService.class).error("Control request failed: {}", (Object)cmd, (Object)re);
        }
    }

    static /* synthetic */ void lambda$createJobMonitorApp$3e967447$1(Topology topology, JsonObject config) {
        JobMonitorApp.declareTopology((Topology)topology);
    }

    static /* synthetic */ void lambda$createIotDeviceApp$3e967447$1(IotProvider this_, Topology topology, JsonObject config) {
        IotDevicePubSub.createApplication((IotDevice)this_.createMessageHubDevice(topology));
    }
}

