/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.connectors.wsclient.javax.websocket.runtime;

import org.apache.edgent.connectors.wsclient.javax.websocket.runtime.WebSocketClientConnector;
import org.apache.edgent.function.Consumer;
import org.apache.edgent.function.Function;

public class WebSocketClientReceiver<T>
implements Consumer<Consumer<T>>,
AutoCloseable {
    private static final long serialVersionUID = 1L;
    protected final WebSocketClientConnector connector;
    private final Function<String, T> toTuple;
    protected Consumer<T> eventHandler;

    public WebSocketClientReceiver(WebSocketClientConnector connector, Function<String, T> toTuple) {
        this.connector = connector;
        this.toTuple = toTuple;
    }

    public void accept(Consumer<T> eventHandler) {
        this.eventHandler = eventHandler;
        this.connector.setReceiver(this);
        try {
            this.connector.client();
        }
        catch (Exception e) {
            this.connector.getLogger().error("{} receiver setup failed", (Object)this.connector.id(), (Object)e);
        }
    }

    void onBinaryMessage(byte[] message) {
        this.connector.getLogger().debug("{} ignoring received binary message (expecting text)", (Object)this.connector.id());
    }

    void onTextMessage(String message) {
        this.eventHandler.accept(this.toTuple.apply((Object)message));
    }

    @Override
    public void close() throws Exception {
        this.connector.close();
    }
}

