/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.connectors.wsclient.javax.websocket.runtime;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Properties;
import javax.websocket.ClientEndpoint;
import javax.websocket.ContainerProvider;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.edgent.connectors.runtime.Connector;
import org.apache.edgent.connectors.wsclient.javax.websocket.runtime.WebSocketClientConnector$$Lambda$1;
import org.apache.edgent.connectors.wsclient.javax.websocket.runtime.WebSocketClientReceiver;
import org.apache.edgent.function.Supplier;
import org.apache.edgent.javax.websocket.EdgentSslContainerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class WebSocketClientConnector
extends Connector<Session>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(WebSocketClientConnector.class);
    private final Properties config;
    private volatile String id;
    private volatile String sid;
    private WebSocketClientReceiver<?> msgReceiver;
    private volatile WebSocketContainer container;
    private final Supplier<WebSocketContainer> containerFn;

    public WebSocketClientConnector(Properties config, Supplier<WebSocketContainer> containerFn) {
        Objects.requireNonNull(config, "config");
        this.config = config;
        this.checkConfig();
        this.containerFn = containerFn != null ? containerFn : WebSocketClientConnector$$Lambda$1.lambdaFactory$(this);
    }

    private void checkConfig() {
        this.requireConfig("ws.uri");
        URI uri = this.getEndpointURI();
        if (!"ws".equals(uri.getScheme()) && !"wss".equals(uri.getScheme())) {
            throw new IllegalArgumentException("ws.uri");
        }
        if (this.optionalConfig("ws.trustStore")) {
            this.requireConfig("ws.trustStorePassword");
        }
        if (this.optionalConfig("ws.keyStore")) {
            this.requireConfig("ws.keyStorePassword");
        }
    }

    void setReceiver(WebSocketClientReceiver<?> msgReceiver) {
        this.msgReceiver = msgReceiver;
    }

    public Logger getLogger() {
        return logger;
    }

    protected Session doConnect(Session session) throws Exception {
        if (session == null || !session.isOpen()) {
            if (session != null) {
                this.doClose(session);
            }
            if (this.container == null) {
                this.container = (WebSocketContainer)this.containerFn.get();
            }
            URI uri = this.getEndpointURI();
            this.getLogger().info("{} connecting uri={}", (Object)this.id(), (Object)uri);
            session = this.container.connectToServer((Object)this, uri);
            this.updateId(session);
            this.getLogger().info("{} connected uri={}", (Object)this.id(), (Object)uri);
        }
        return session;
    }

    private WebSocketContainer getWebSocketContainer() throws RuntimeException {
        URI uri = this.getEndpointURI();
        if ("ws".equals(uri.getScheme()) || this.config.getProperty("ws.trustStore") == null && this.config.getProperty("ws.keyStore") == null && System.getProperty("javax.net.ssl.keyStore") == null) {
            return ContainerProvider.getWebSocketContainer();
        }
        this.getLogger().info("##### Using ContainerProvider.getWebSocketContainer() workaround for SSL #####");
        return EdgentSslContainerProvider.getSslWebSocketContainer((Properties)this.config);
    }

    private URI getEndpointURI() throws RuntimeException {
        String uriStr = this.config.getProperty("ws.uri");
        try {
            return new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("ws.uri", e);
        }
    }

    private void requireConfig(String id) {
        if (this.config.getProperty(id) == null) {
            throw new IllegalArgumentException(id);
        }
    }

    private boolean optionalConfig(String id) {
        return this.config.getProperty(id) != null;
    }

    protected void doDisconnect(Session session) throws Exception {
        this.doClose(session);
    }

    protected void doClose(Session session) throws Exception {
        this.getLogger().debug("{} doClose {}", (Object)this.id(), (Object)session);
        session.close();
    }

    private void updateId(Session session) {
        this.sid = session.getId();
        this.id = null;
    }

    protected String id() {
        if (this.id == null) {
            this.id = "WSCLIENT " + this.toString().substring(this.toString().indexOf(64) + 1) + " sid=" + this.sid;
        }
        return this.id;
    }

    @OnError
    public void onError(Session client, Throwable t) {
        this.getLogger().error("{} onError {}", (Object)this.id(), (Object)t);
    }

    @OnMessage
    public void onTextMessage(String message) {
        this.getLogger().trace("{} onTextMessage {}", (Object)this.id(), (Object)message);
        if (this.msgReceiver != null) {
            this.msgReceiver.onTextMessage(message);
        }
    }

    @OnMessage
    public void onBinaryMessage(byte[] message) {
        this.getLogger().trace("{} onBinaryMessage {} bytes.", (Object)this.id(), (Object)message.length);
        if (this.msgReceiver != null) {
            this.msgReceiver.onBinaryMessage(message);
        }
    }

    void sendBinary(byte[] bytes) {
        while (true) {
            Session session = this.getConnectedSession();
            try {
                session.getBasicRemote().sendBinary(ByteBuffer.wrap(bytes));
                this.getLogger().trace("{} sendBinary {} bytes.", (Object)this.id(), (Object)bytes.length);
                return;
            }
            catch (IOException e) {
                if (!session.isOpen()) {
                    this.connectionLost(e);
                    this.getLogger().error("{} sendBinary {} bytes failed. Retrying following connection lost", (Object)this.id(), (Object)bytes.length);
                    continue;
                }
                this.getLogger().error("{} sendBinary {} bytes failed", new Object[]{this.id(), bytes.length, e});
                throw new RuntimeException(e);
            }
            break;
        }
    }

    void sendText(String msg) {
        while (true) {
            Session session = this.getConnectedSession();
            try {
                session.getBasicRemote().sendText(msg);
                this.getLogger().trace("{} sendText {}", (Object)this.id(), (Object)msg);
                return;
            }
            catch (IOException e) {
                if (!session.isOpen()) {
                    this.connectionLost(e);
                    this.getLogger().error("{} sendText {} chars failed. Retrying following connection lost", (Object)this.id(), (Object)msg.length());
                    continue;
                }
                this.getLogger().error("{} sendText {} chars failed", new Object[]{this.id(), msg.length(), e});
                throw new RuntimeException(e);
            }
            break;
        }
    }

    private Session getConnectedSession() {
        try {
            return (Session)this.client();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ WebSocketContainer lambda$new$2a1af9d8$1(WebSocketClientConnector this_) {
        return this_.getWebSocketContainer();
    }
}

