/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.connectors.wsclient.javax.websocket;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.Properties;
import javax.websocket.WebSocketContainer;
import org.apache.edgent.connectors.wsclient.WebSocketClient;
import org.apache.edgent.connectors.wsclient.javax.websocket.Jsr356WebSocketClient$$Lambda$1;
import org.apache.edgent.connectors.wsclient.javax.websocket.Jsr356WebSocketClient$$Lambda$4;
import org.apache.edgent.connectors.wsclient.javax.websocket.Jsr356WebSocketClient$$Lambda$5;
import org.apache.edgent.connectors.wsclient.javax.websocket.Jsr356WebSocketClient$$Lambda$6;
import org.apache.edgent.connectors.wsclient.javax.websocket.runtime.WebSocketClientBinaryReceiver;
import org.apache.edgent.connectors.wsclient.javax.websocket.runtime.WebSocketClientBinarySender;
import org.apache.edgent.connectors.wsclient.javax.websocket.runtime.WebSocketClientConnector;
import org.apache.edgent.connectors.wsclient.javax.websocket.runtime.WebSocketClientReceiver;
import org.apache.edgent.connectors.wsclient.javax.websocket.runtime.WebSocketClientSender;
import org.apache.edgent.function.Function;
import org.apache.edgent.function.Supplier;
import org.apache.edgent.topology.TSink;
import org.apache.edgent.topology.TStream;
import org.apache.edgent.topology.Topology;
import org.apache.edgent.topology.json.JsonFunctions;

public class Jsr356WebSocketClient
implements WebSocketClient {
    private final Topology t;
    private final WebSocketClientConnector connector;
    private int senderCnt;
    private int receiverCnt;

    public Jsr356WebSocketClient(Topology t, Properties config) {
        this(t, config, null);
    }

    public Jsr356WebSocketClient(Topology t, Properties config, Supplier<WebSocketContainer> containerFn) {
        Objects.requireNonNull(t, "t");
        Objects.requireNonNull(config, "config");
        this.t = t;
        this.connector = new WebSocketClientConnector(config, containerFn);
    }

    public TSink<JsonObject> send(TStream<JsonObject> stream) {
        Objects.requireNonNull(stream, "stream");
        return this.sendText(stream, JsonFunctions.asString());
    }

    public TSink<String> sendString(TStream<String> stream) {
        Objects.requireNonNull(stream, "stream");
        return this.sendText(stream, Jsr356WebSocketClient$$Lambda$1.lambdaFactory$());
    }

    private <T> TSink<T> sendText(TStream<T> stream, Function<T, String> toPayload) {
        Objects.requireNonNull(stream, "stream");
        Objects.requireNonNull(toPayload, "toPayload");
        this.checkAddSender();
        return stream.sink(new WebSocketClientSender<T>(this.connector, toPayload));
    }

    public TSink<byte[]> sendBytes(TStream<byte[]> stream) {
        Objects.requireNonNull(stream, "stream");
        return this.sendBinary(stream, Jsr356WebSocketClient$$Lambda$4.lambdaFactory$());
    }

    private <T> TSink<T> sendBinary(TStream<T> stream, Function<T, byte[]> toPayload) {
        Objects.requireNonNull(stream, "stream");
        Objects.requireNonNull(toPayload, "toPayload");
        this.checkAddSender();
        return stream.sink(new WebSocketClientBinarySender<T>(this.connector, toPayload));
    }

    private void checkAddSender() throws IllegalStateException {
        if (++this.senderCnt > 1) {
            throw new IllegalStateException("More than one sender specified");
        }
    }

    public TStream<JsonObject> receive() {
        return this.receiveText(JsonFunctions.fromString());
    }

    public TStream<String> receiveString() {
        return this.receiveText(Jsr356WebSocketClient$$Lambda$5.lambdaFactory$());
    }

    private <T> TStream<T> receiveText(Function<String, T> toTuple) {
        this.checkAddReceiver();
        return this.t.events(new WebSocketClientReceiver<T>(this.connector, toTuple));
    }

    public TStream<byte[]> receiveBytes() {
        return this.receiveBinary(Jsr356WebSocketClient$$Lambda$6.lambdaFactory$());
    }

    private <T> TStream<T> receiveBinary(Function<byte[], T> toTuple) {
        this.checkAddReceiver();
        return this.t.events(new WebSocketClientBinaryReceiver<T>(this.connector, toTuple));
    }

    private void checkAddReceiver() throws IllegalStateException {
        if (++this.receiverCnt > 1) {
            throw new IllegalStateException("More than one receiver specified");
        }
    }

    public Topology topology() {
        return this.t;
    }

    static /* synthetic */ byte[] lambda$receiveBytes$ee5d1fd6$1(byte[] payload) {
        return payload;
    }

    static /* synthetic */ String lambda$receiveString$646d88b3$1(String tuple) {
        return tuple;
    }

    static /* synthetic */ byte[] lambda$sendBytes$797658f3$1(byte[] tuple) {
        return tuple;
    }

    static /* synthetic */ String lambda$sendString$6c64dc53$1(String tuple) {
        return tuple;
    }
}

