/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.quic;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.IdleStateEvent;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.transport.quic.QuicNettyChannel;

@ChannelHandler.Sharable
public class QuicNettyServerHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(QuicNettyServerHandler.class);
    private final Map<String, Channel> channels = new ConcurrentHashMap<String, Channel>();
    private final URL url;
    private final ChannelHandler handler;

    public QuicNettyServerHandler(URL url, ChannelHandler handler) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler == null");
        }
        this.url = url;
        this.handler = handler;
    }

    public Map<String, Channel> getChannels() {
        return this.channels;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        QuicNettyChannel channel = QuicNettyChannel.getOrAddChannel(ctx.channel(), this.url, this.handler);
        if (channel != null) {
            this.channels.put(NetUtils.toAddressString((InetSocketAddress)((InetSocketAddress)ctx.channel().remoteAddress())), (Channel)channel);
        }
        this.handler.connected((Channel)channel);
        if (logger.isInfoEnabled()) {
            logger.info("The connection of " + channel.getRemoteAddress() + " -> " + channel.getLocalAddress() + " is established.");
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        QuicNettyChannel channel = QuicNettyChannel.getOrAddChannel(ctx.channel(), this.url, this.handler);
        try {
            this.channels.remove(NetUtils.toAddressString((InetSocketAddress)((InetSocketAddress)ctx.channel().remoteAddress())));
            this.handler.disconnected((Channel)channel);
        }
        finally {
            QuicNettyChannel.removeChannel(ctx.channel());
        }
        if (logger.isInfoEnabled()) {
            logger.info("The connection of " + channel.getRemoteAddress() + " -> " + channel.getLocalAddress() + " is disconnected.");
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        QuicNettyChannel channel = QuicNettyChannel.getOrAddChannel(ctx.channel(), this.url, this.handler);
        this.handler.received((Channel)channel, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        super.write(ctx, msg, promise);
        QuicNettyChannel channel = QuicNettyChannel.getOrAddChannel(ctx.channel(), this.url, this.handler);
        this.handler.sent((Channel)channel, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            QuicNettyChannel channel = QuicNettyChannel.getOrAddChannel(ctx.channel(), this.url, this.handler);
            try {
                logger.info("IdleStateEvent triggered, close channel " + (Object)((Object)channel));
                channel.close();
            }
            finally {
                QuicNettyChannel.removeChannelIfDisconnected(ctx.channel());
            }
        }
        super.userEventTriggered(ctx, evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        QuicNettyChannel channel = QuicNettyChannel.getOrAddChannel(ctx.channel(), this.url, this.handler);
        try {
            this.handler.caught((Channel)channel, cause);
        }
        finally {
            QuicNettyChannel.removeChannelIfDisconnected(ctx.channel());
        }
    }
}

