/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.quic;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.incubator.codec.quic.InsecureQuicTokenHandler;
import io.netty.incubator.codec.quic.QuicServerCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicSslContextBuilder;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.incubator.codec.quic.QuicTokenHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.remoting.transport.AbstractServer;
import org.apache.dubbo.remoting.transport.dispatcher.ChannelHandlers;
import org.apache.dubbo.remoting.transport.quic.NettyCodecAdapter;
import org.apache.dubbo.remoting.transport.quic.QuicNettyEventLoopFactory;
import org.apache.dubbo.remoting.transport.quic.QuicNettyServerHandler;
import org.apache.dubbo.remoting.utils.UrlUtils;

public class QuicNettyServer
extends AbstractServer
implements RemotingServer {
    private static final Logger logger = LoggerFactory.getLogger(QuicNettyServer.class);
    private Map<String, Channel> channels;
    private Bootstrap bootstrap;
    private io.netty.channel.Channel channel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public QuicNettyServer(URL url, ChannelHandler handler) throws RemotingException {
        super(ExecutorUtil.setThreadName((URL)url, (String)"DubboServerHandler"), ChannelHandlers.wrap((ChannelHandler)handler, (URL)url));
    }

    protected void doOpen() throws Throwable {
        this.bossGroup = QuicNettyEventLoopFactory.eventLoopGroup(1, "QuicNettyServerBoss");
        final QuicNettyServerHandler nettyServerHandler = new QuicNettyServerHandler(this.getUrl(), (ChannelHandler)this);
        this.channels = nettyServerHandler.getChannels();
        SelfSignedCertificate selfSignedCertificate = new SelfSignedCertificate();
        QuicSslContext context = QuicSslContextBuilder.forServer((File)selfSignedCertificate.privateKey(), null, (File)selfSignedCertificate.certificate()).applicationProtocols(new String[]{"http/0.9"}).build();
        this.bootstrap = new Bootstrap();
        io.netty.channel.ChannelHandler codec = ((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)new QuicServerCodecBuilder().sslContext(context)).maxIdleTimeout(5000L, TimeUnit.MILLISECONDS)).initialMaxData(10000000L)).initialMaxStreamDataBidirectionalLocal(1000000L)).initialMaxStreamDataBidirectionalRemote(1000000L)).initialMaxStreamsBidirectional(100L)).initialMaxStreamsUnidirectional(100L)).tokenHandler((QuicTokenHandler)InsecureQuicTokenHandler.INSTANCE).streamHandler((io.netty.channel.ChannelHandler)new ChannelInitializer<QuicStreamChannel>(){

            protected void initChannel(QuicStreamChannel ch) {
                int idleTimeout = UrlUtils.getIdleTimeout((URL)QuicNettyServer.this.getUrl());
                NettyCodecAdapter adapter = new NettyCodecAdapter(QuicNettyServer.this.getCodec(), QuicNettyServer.this.getUrl(), (ChannelHandler)QuicNettyServer.this);
                ch.pipeline().addLast("decoder", adapter.getDecoder()).addLast("encoder", adapter.getEncoder()).addLast("server-idle-handler", (io.netty.channel.ChannelHandler)new IdleStateHandler(0L, 0L, (long)idleTimeout, TimeUnit.MILLISECONDS)).addLast("handler", (io.netty.channel.ChannelHandler)nettyServerHandler);
            }
        }).build();
        InetSocketAddress address = this.getBindAddress();
        logger.info("bind address:" + address);
        ChannelFuture channelFuture = ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.bossGroup)).channel(NioDatagramChannel.class)).handler(codec)).bind((SocketAddress)address);
        channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture1 -> logger.info("bind finish:" + channelFuture1)));
    }

    protected void doClose() throws Throwable {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        try {
            Collection<Channel> channels = this.getChannels();
            if (channels != null && channels.size() > 0) {
                for (Channel channel : channels) {
                    try {
                        channel.close();
                    }
                    catch (Throwable e) {
                        logger.warn(e.getMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        try {
            if (this.bootstrap != null) {
                this.bossGroup.shutdownGracefully().syncUninterruptibly();
                this.workerGroup.shutdownGracefully().syncUninterruptibly();
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        try {
            if (this.channels != null) {
                this.channels.clear();
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public Collection<Channel> getChannels() {
        ArrayList<Channel> chs = new ArrayList<Channel>(this.channels.size());
        chs.addAll(this.channels.values());
        return chs;
    }

    public Channel getChannel(InetSocketAddress remoteAddress) {
        return this.channels.get(NetUtils.toAddressString((InetSocketAddress)remoteAddress));
    }

    public boolean canHandleIdle() {
        return true;
    }

    public boolean isBound() {
        return this.channel.isActive();
    }
}

