/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.quic;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;

public class QuicNettyEventLoopFactory {
    public static EventLoopGroup eventLoopGroup(int threads, String threadFactoryName) {
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(threadFactoryName, true);
        return QuicNettyEventLoopFactory.shouldEpoll() ? new EpollEventLoopGroup(threads, (ThreadFactory)threadFactory) : new NioEventLoopGroup(threads, (ThreadFactory)threadFactory);
    }

    public static Class<? extends SocketChannel> socketChannelClass() {
        return QuicNettyEventLoopFactory.shouldEpoll() ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    public static Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        return QuicNettyEventLoopFactory.shouldEpoll() ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
    }

    private static boolean shouldEpoll() {
        if (Boolean.parseBoolean(System.getProperty("netty.epoll.enable", "false"))) {
            String osName = System.getProperty("os.name");
            return osName.toLowerCase().contains("linux") && Epoll.isAvailable();
        }
        return false;
    }
}

