/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.quic;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicClientCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicSslContextBuilder;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.incubator.codec.quic.QuicStreamType;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.transport.AbstractClient;
import org.apache.dubbo.remoting.transport.quic.NettyCodecAdapter;
import org.apache.dubbo.remoting.transport.quic.QuicNettyChannel;
import org.apache.dubbo.remoting.transport.quic.QuicNettyClientHandler;
import org.apache.dubbo.remoting.transport.quic.QuicNettyEventLoopFactory;
import org.apache.dubbo.remoting.utils.UrlUtils;

public class QuicNettyClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(QuicNettyClient.class);
    private static final EventLoopGroup EVENT_LOOP_GROUP = QuicNettyEventLoopFactory.eventLoopGroup(Constants.DEFAULT_IO_THREADS, "QuicNettyClientWorker");
    private Bootstrap bootstrap;
    private volatile io.netty.channel.Channel qchannel;
    private volatile io.netty.channel.Channel channel;
    private volatile io.netty.channel.Channel schannel;

    public QuicNettyClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, QuicNettyClient.wrapChannelHandler((URL)url, (ChannelHandler)handler));
    }

    protected void doOpen() throws Throwable {
        QuicSslContext context = QuicSslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).applicationProtocols(new String[]{"http/0.9"}).build();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        io.netty.channel.ChannelHandler codec = ((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)new QuicClientCodecBuilder().sslContext(context)).maxIdleTimeout(5000L, TimeUnit.MILLISECONDS)).initialMaxData(10000000L)).initialMaxStreamDataBidirectionalLocal(1000000L)).build();
        Bootstrap bs = new Bootstrap();
        this.qchannel = ((Bootstrap)((Bootstrap)((Bootstrap)bs.group((EventLoopGroup)group)).channel(NioDatagramChannel.class)).handler(codec)).bind(0).sync().channel();
        logger.info("quic client do open finish");
    }

    protected void doConnect() throws Throwable {
        logger.info("quic client do connect");
        final QuicNettyClientHandler nettyClientHandler = new QuicNettyClientHandler(this.getUrl(), (ChannelHandler)this);
        InetSocketAddress address = this.getConnectAddress();
        logger.info("quic connect address:" + address);
        QuicChannel quicChannel = (QuicChannel)QuicChannel.newBootstrap((io.netty.channel.Channel)this.qchannel).streamHandler((io.netty.channel.ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) {
                ctx.close();
            }
        }).remoteAddress((SocketAddress)address).connect().get(5L, TimeUnit.SECONDS);
        this.schannel = (io.netty.channel.Channel)quicChannel.createStream(QuicStreamType.BIDIRECTIONAL, (io.netty.channel.ChannelHandler)new ChannelInitializer<QuicStreamChannel>(){

            protected void initChannel(QuicStreamChannel quicStreamChannel) throws Exception {
                NettyCodecAdapter adapter = new NettyCodecAdapter(QuicNettyClient.this.getCodec(), QuicNettyClient.this.getUrl(), (ChannelHandler)QuicNettyClient.this);
                int heartbeatInterval = UrlUtils.getHeartbeat((URL)QuicNettyClient.this.getUrl());
                quicStreamChannel.pipeline().addLast(new io.netty.channel.ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                        if (evt == ChannelInputShutdownReadComplete.INSTANCE) {
                            ((QuicChannel)ctx.channel().parent()).close(true, 0, ctx.alloc().directBuffer(16).writeBytes(new byte[]{107, 116, 104, 120, 98, 121, 101}));
                        }
                    }
                }}).addLast("decoder", adapter.getDecoder()).addLast("encoder", adapter.getEncoder()).addLast("client-idle-handler", (io.netty.channel.ChannelHandler)new IdleStateHandler((long)heartbeatInterval, 0L, 0L, TimeUnit.MILLISECONDS)).addLast("handler", (io.netty.channel.ChannelHandler)nettyClientHandler);
            }
        }).sync().getNow();
    }

    public boolean isConnected() {
        if (this.schannel == null) {
            return false;
        }
        return this.schannel.isActive();
    }

    protected void doDisConnect() throws Throwable {
        try {
            QuicNettyChannel.removeChannelIfDisconnected(this.channel);
        }
        catch (Throwable t) {
            logger.warn(t.getMessage());
        }
    }

    protected void doClose() throws Throwable {
    }

    protected Channel getChannel() {
        io.netty.channel.Channel c = this.schannel;
        if (c == null) {
            return null;
        }
        return QuicNettyChannel.getOrAddChannel(c, this.getUrl(), (ChannelHandler)this);
    }

    io.netty.channel.Channel getNettyChannel() {
        return this.schannel;
    }

    public boolean canHandleIdle() {
        return true;
    }
}

