/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.quic;

import io.netty.channel.ChannelFuture;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.transport.AbstractChannel;
import org.apache.dubbo.remoting.transport.quic.QuicNettyClient;
import org.apache.dubbo.remoting.utils.PayloadDropper;

final class QuicNettyChannel
extends AbstractChannel {
    private static final Logger logger = LoggerFactory.getLogger(QuicNettyChannel.class);
    private static final ConcurrentMap<io.netty.channel.Channel, QuicNettyChannel> CHANNEL_MAP = new ConcurrentHashMap<io.netty.channel.Channel, QuicNettyChannel>();
    private final io.netty.channel.Channel channel;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final AtomicBoolean active = new AtomicBoolean(false);
    private InetSocketAddress remoteAddress;

    private QuicNettyChannel(io.netty.channel.Channel channel, URL url, ChannelHandler handler) {
        super(url, handler);
        if (channel == null) {
            throw new IllegalArgumentException("netty channel == null;");
        }
        this.channel = channel;
    }

    static QuicNettyChannel getOrAddChannel(io.netty.channel.Channel ch, URL url, ChannelHandler handler) {
        QuicNettyChannel ret;
        if (ch == null) {
            return null;
        }
        InetSocketAddress v = null;
        if (ch instanceof QuicStreamChannel) {
            QuicStreamChannel qsc = (QuicStreamChannel)ch;
            QuicChannel qqc = qsc.parent();
            try {
                Field f = qqc.getClass().getDeclaredField("remote");
                f.setAccessible(true);
                v = (InetSocketAddress)f.get(qqc);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                logger.error(e.getMessage());
            }
        }
        if ((ret = (QuicNettyChannel)((Object)CHANNEL_MAP.get(ch))) == null) {
            QuicNettyChannel nettyChannel = new QuicNettyChannel(ch, url, handler);
            nettyChannel.setRemoteAddress(v);
            if (ch.isActive()) {
                nettyChannel.markActive(true);
                ret = CHANNEL_MAP.putIfAbsent(ch, nettyChannel);
            }
            if (ret == null) {
                ret = nettyChannel;
            }
        }
        return ret;
    }

    static void removeChannelIfDisconnected(io.netty.channel.Channel ch) {
        QuicNettyChannel nettyChannel;
        if (ch != null && !ch.isActive() && (nettyChannel = (QuicNettyChannel)((Object)CHANNEL_MAP.remove(ch))) != null) {
            nettyChannel.markActive(false);
        }
    }

    static void removeChannel(io.netty.channel.Channel ch) {
        QuicNettyChannel nettyChannel;
        if (ch != null && (nettyChannel = (QuicNettyChannel)((Object)CHANNEL_MAP.remove(ch))) != null) {
            nettyChannel.markActive(false);
        }
    }

    public InetSocketAddress getLocalAddress() {
        int port = this.getUrl().getPort();
        InetSocketAddress res = new InetSocketAddress(port);
        return res;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public boolean isConnected() {
        return !this.isClosed() && this.active.get();
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void markActive(boolean isActive) {
        this.active.set(isActive);
    }

    public void send(Object message, boolean sent) throws RemotingException {
        super.send(message, sent);
        boolean success = true;
        int timeout = 0;
        try {
            Throwable cause;
            ChannelFuture future = this.channel.writeAndFlush(message);
            if (sent) {
                timeout = this.getUrl().getPositiveParameter("timeout", 1000);
                success = future.await((long)timeout);
            }
            if ((cause = future.cause()) != null) {
                throw cause;
            }
        }
        catch (Throwable e) {
            QuicNettyChannel.removeChannelIfDisconnected(this.channel);
            throw new RemotingException((Channel)this, "Failed to send message " + PayloadDropper.getRequestWithoutData((Object)message) + " to " + this.getRemoteAddress() + ", cause: " + e.getMessage(), e);
        }
        if (!success) {
            throw new RemotingException((Channel)this, "Failed to send message " + PayloadDropper.getRequestWithoutData((Object)message) + " to " + this.getRemoteAddress() + "in timeout(" + timeout + "ms) limit");
        }
    }

    public void close() {
        try {
            super.close();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        try {
            QuicNettyChannel.removeChannelIfDisconnected(this.channel);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        try {
            this.attributes.clear();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        try {
            if (logger.isInfoEnabled()) {
                logger.info("Close netty channel " + this.channel);
            }
            this.channel.close();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.channel == null ? 0 : this.channel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof QuicNettyClient) {
            QuicNettyClient client = (QuicNettyClient)((Object)obj);
            return this.channel.equals(client.getNettyChannel());
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        QuicNettyChannel other = (QuicNettyChannel)((Object)obj);
        return !(this.channel == null ? other.channel != null : !this.channel.equals(other.channel));
    }

    public String toString() {
        return "NettyChannel [channel=" + this.channel + "]";
    }
}

