/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.mock.utils;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import java.util.Objects;

public class ProtobufUtil {
    private ProtobufUtil() {
    }

    public static boolean isProtobufClass(Class<?> targetType) {
        if (Objects.isNull(targetType)) {
            return false;
        }
        Class<?> superType = targetType.getSuperclass();
        if (Objects.isNull(superType)) {
            return false;
        }
        String superTypeName = superType.getName();
        return Objects.equals(superTypeName, "com.google.protobuf.GeneratedMessageV3") || Objects.equals(superTypeName, "com.google.protobuf.GeneratedMessage");
    }

    public static String protobufToJson(Object o) {
        try {
            return JsonFormat.printToString((Message)((Message)o));
        }
        catch (Exception e) {
            return o.toString();
        }
    }
}

