/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.mock.handler;

public class ResultContext {
    private String serviceName;
    private String methodName;
    private Class<?> targetType;
    private String data;

    private ResultContext(Builder builder) {
        this.targetType = builder.targetType;
        this.data = builder.data;
        this.serviceName = builder.serviceName;
        this.methodName = builder.methodName;
    }

    public static Builder newResultContext() {
        return new Builder();
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public void setTargetType(Class<?> targetType) {
        this.targetType = targetType;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String toString() {
        return "ResultContext{serviceName='" + this.serviceName + '\'' + ", methodName='" + this.methodName + '\'' + ", targetType=" + this.targetType + ", data='" + this.data + '\'' + '}';
    }

    public static final class Builder {
        private Class<?> targetType;
        private String data;
        private String serviceName;
        private String methodName;

        private Builder() {
        }

        public ResultContext build() {
            return new ResultContext(this);
        }

        public Builder targetType(Class<?> targetType) {
            this.targetType = targetType;
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }
    }
}

