/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.mock.handler;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import java.lang.reflect.Method;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.mock.exception.HandleFailException;
import org.apache.dubbo.mock.handler.ResultContext;
import org.apache.dubbo.mock.handler.TypeHandler;
import org.apache.dubbo.mock.utils.ProtobufUtil;

public class ProtobufTypeHandler
implements TypeHandler<Object> {
    private static final Logger logger = LoggerFactory.getLogger(ProtobufTypeHandler.class);

    @Override
    public boolean isMatch(ResultContext resultContext) {
        return ProtobufUtil.isProtobufClass(resultContext.getTargetType());
    }

    @Override
    public Object handleResult(ResultContext resultContext) {
        try {
            Method buildMethod = resultContext.getTargetType().getMethod("newBuilder", new Class[0]);
            Message.Builder message = (Message.Builder)buildMethod.invoke(null, new Object[0]);
            JsonFormat.merge((CharSequence)resultContext.getData(), (Message.Builder)message);
            return message.build();
        }
        catch (Exception e) {
            logger.warn("[Dubbo Mock] handle protobuf object failed", (Throwable)e);
            throw new HandleFailException(e);
        }
    }
}

