/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.mock.handler;

import com.alibaba.fastjson2.JSON;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.dubbo.mock.exception.HandleFailException;
import org.apache.dubbo.mock.handler.ResultContext;
import org.apache.dubbo.mock.handler.TypeHandler;

public class JsonTypeHandler
implements TypeHandler<Object> {
    @Override
    public boolean isMatch(ResultContext resultContext) {
        return true;
    }

    @Override
    public Object handleResult(ResultContext resultContext) {
        try {
            Class<?> targetType = resultContext.getTargetType();
            Class<?> serviceType = Class.forName(resultContext.getServiceName());
            Method[] methods = serviceType.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Type genericReturnType;
                Method method = methods[i];
                if (!Objects.equals(method.getName(), resultContext.getMethodName()) || !((genericReturnType = method.getGenericReturnType()) instanceof ParameterizedType)) continue;
                return JSON.parseObject((String)resultContext.getData(), (Type)genericReturnType);
            }
            return JSON.parseObject((String)resultContext.getData(), targetType);
        }
        catch (Exception e) {
            throw new HandleFailException(e);
        }
    }
}

