/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.mock.handler;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.apache.dubbo.mock.handler.ResultContext;
import org.apache.dubbo.mock.handler.TypeHandler;

public class DateTypeHandler
implements TypeHandler<Date> {
    @Override
    public boolean isMatch(ResultContext resultContext) {
        return Objects.equals(Date.class, resultContext.getTargetType());
    }

    @Override
    public Date handleResult(ResultContext resultContext) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return dateFormat.parse(resultContext.getData());
        }
        catch (Exception e) {
            return new Date(Long.parseLong(resultContext.getData()));
        }
    }
}

