/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.mock.handler;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.mock.handler.BigDecimalTypeHandler;
import org.apache.dubbo.mock.handler.BigIntegerTypeHandler;
import org.apache.dubbo.mock.handler.BooleanTypeHandler;
import org.apache.dubbo.mock.handler.ByteTypeHandler;
import org.apache.dubbo.mock.handler.DateTypeHandler;
import org.apache.dubbo.mock.handler.DoubleTypeHandler;
import org.apache.dubbo.mock.handler.FloatTypeHandler;
import org.apache.dubbo.mock.handler.IntegerTypeHandler;
import org.apache.dubbo.mock.handler.JsonTypeHandler;
import org.apache.dubbo.mock.handler.LongTypeHandler;
import org.apache.dubbo.mock.handler.ProtobufTypeHandler;
import org.apache.dubbo.mock.handler.ResultContext;
import org.apache.dubbo.mock.handler.StringTypeHandler;
import org.apache.dubbo.mock.handler.TypeHandler;
import org.apache.dubbo.mock.handler.UnknownTypeHandler;

public class CommonTypeHandler
implements TypeHandler<Object> {
    private static final Logger logger = LoggerFactory.getLogger(CommonTypeHandler.class);
    private List<TypeHandler> typeHandlers;
    private UnknownTypeHandler unknownTypeHandler = new UnknownTypeHandler();
    private JsonTypeHandler jsonTypeHandler = new JsonTypeHandler();

    public CommonTypeHandler() {
        this.typeHandlers = Arrays.asList(new StringTypeHandler(), new IntegerTypeHandler(), new LongTypeHandler(), new BigDecimalTypeHandler(), new ProtobufTypeHandler(), new DateTypeHandler(), new BooleanTypeHandler(), new ByteTypeHandler(), new DoubleTypeHandler(), new FloatTypeHandler(), new BigIntegerTypeHandler());
    }

    @Override
    public boolean isMatch(ResultContext resultContext) {
        return false;
    }

    @Override
    public Object handleResult(ResultContext resultContext) {
        if (Objects.isNull(resultContext.getData())) {
            return null;
        }
        try {
            Optional<TypeHandler> typeHandler;
            if (Objects.isNull(resultContext.getTargetType())) {
                Class<?> serviceType = Class.forName(resultContext.getServiceName());
                if (Objects.isNull(serviceType)) {
                    return null;
                }
                Method[] methods = serviceType.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    if (!Objects.equals(resultContext.getMethodName(), method.getName())) continue;
                    resultContext.setTargetType(method.getReturnType());
                    break;
                }
            }
            if ((typeHandler = this.typeHandlers.stream().filter(th -> th.isMatch(resultContext)).findFirst()).isPresent()) {
                return typeHandler.get().handleResult(resultContext);
            }
            return this.jsonTypeHandler.handleResult(resultContext);
        }
        catch (Exception e) {
            logger.warn("[Dubbo Mock] handle the common result failed, will use unknown type handler.", (Throwable)e);
            return this.unknownTypeHandler.handleResult(resultContext);
        }
    }
}

