/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.mock.filter;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.lang.ShutdownHookCallbacks;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.apache.dubbo.config.utils.ConfigValidationUtils;
import org.apache.dubbo.mock.api.MockContext;
import org.apache.dubbo.mock.api.MockResult;
import org.apache.dubbo.mock.api.MockService;
import org.apache.dubbo.mock.handler.CommonTypeHandler;
import org.apache.dubbo.mock.handler.ResultContext;
import org.apache.dubbo.mock.handler.TypeHandler;
import org.apache.dubbo.mock.utils.ProtobufUtil;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

@Activate(group={"consumer"})
public class AdminMockFilter
implements ClusterFilter {
    private static final Logger log = LoggerFactory.getLogger(AdminMockFilter.class);
    private static final String ENABLE_MOCK_KEY = "enable.dubbo.admin.mock";
    private final TypeHandler typeHandler = new CommonTypeHandler();
    private static final boolean ENABLE_ADMIN_MOCK = Boolean.parseBoolean(System.getProperty("enable.dubbo.admin.mock", Boolean.FALSE.toString()));
    private static final ProxyFactory proxyFactory = (ProxyFactory)ExtensionLoader.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
    private static final Protocol protocol = (Protocol)ExtensionLoader.getExtensionLoader(Protocol.class).getAdaptiveExtension();
    private MockService mockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MockService getMockService() {
        if (Objects.nonNull(this.mockService)) {
            return this.mockService;
        }
        AdminMockFilter adminMockFilter = this;
        synchronized (adminMockFilter) {
            if (Objects.nonNull(this.mockService)) {
                return this.mockService;
            }
            ReferenceConfig mockServiceConfig = new ReferenceConfig();
            mockServiceConfig.setCheck(Boolean.valueOf(false));
            mockServiceConfig.setInterface(MockService.class);
            mockServiceConfig.setRegistries(DubboBootstrap.getInstance().getConfigManager().getDefaultRegistries());
            List urls = ConfigValidationUtils.loadRegistries((AbstractInterfaceConfig)mockServiceConfig, (boolean)false);
            if (CollectionUtils.isEmpty((Collection)urls)) {
                return null;
            }
            URL url = (URL)urls.get(0);
            HashMap<String, String> map = new HashMap<String, String>();
            ReferenceConfigBase.appendRuntimeParameters(map);
            map.put("interface", MockService.class.getName());
            map.put("side", "consumer");
            AbstractConfig.appendParameters(map, (Object)mockServiceConfig.getApplication());
            AbstractConfig.appendParameters(map, (Object)mockServiceConfig.getModule());
            AbstractConfig.appendParameters(map, (Object)mockServiceConfig);
            url = url.putAttribute("refer", map);
            Invoker invoker = protocol.refer(MockService.class, url);
            this.mockService = (MockService)proxyFactory.getProxy(invoker);
            ((ShutdownHookCallbacks)ScopeModelUtil.getApplicationModel((ScopeModel)mockServiceConfig.getScopeModel()).getBeanFactory().getBean(ShutdownHookCallbacks.class)).addCallback(() -> ((Invoker)invoker).destroy());
            return this.mockService;
        }
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (!ENABLE_ADMIN_MOCK) {
            return invoker.invoke(invocation);
        }
        String interfaceName = invocation.getTargetServiceUniqueName();
        String methodName = invocation.getMethodName();
        Object[] params = this.solveParams(invocation.getArguments());
        if (Objects.equals(interfaceName, MockService.class.getName())) {
            return invoker.invoke(invocation);
        }
        MockService mockService = this.getMockService();
        if (Objects.isNull(mockService)) {
            log.warn("[Admin Mock] cloud not find MockService, will ignore this mock.");
            return invoker.invoke(invocation);
        }
        MockContext mockContext = MockContext.newMockContext().serviceName(interfaceName).methodName(methodName).arguments(params).build();
        MockResult mockResult = mockService.mock(mockContext);
        if (!mockResult.getEnable()) {
            return invoker.invoke(invocation);
        }
        Class returnType = ((RpcInvocation)invocation).getReturnType();
        ResultContext resultContext = ResultContext.newResultContext().data(mockResult.getContent()).targetType(returnType).serviceName(interfaceName).methodName(methodName).build();
        Object data = this.typeHandler.handleResult(resultContext);
        AppResponse appResponse = new AppResponse(data);
        CompletableFuture<AppResponse> appResponseFuture = new CompletableFuture<AppResponse>();
        appResponseFuture.complete(appResponse);
        return new AsyncRpcResult(appResponseFuture, invocation);
    }

    private Object[] solveParams(Object[] arguments) {
        if (Objects.isNull(arguments)) {
            return null;
        }
        Object[] params = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            params[i] = Objects.isNull(argument) ? null : (ProtobufUtil.isProtobufClass(argument.getClass()) ? ProtobufUtil.protobufToJson(argument) : argument);
        }
        return params;
    }
}

