/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.loadbalance;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcStatus;
import org.apache.dubbo.rpc.cluster.loadbalance.AbstractLoadBalance;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class PeakEwmaLoadBalance
extends AbstractLoadBalance {
    public static final String NAME = "peakewma";
    private static final String PEAK_EWMA_DECAY_TIME = "peakEwmaDecayTime";
    private static final double PENALTY = 1.40737488355327E14;
    private static double decayTime = ApplicationModel.getEnvironment().getConfiguration().getInt("peakEwmaDecayTime", 10000);
    private ConcurrentMap<RpcStatus, Metric> methodMap = new ConcurrentHashMap<RpcStatus, Metric>();

    protected <T> Invoker<T> doSelect(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        int length = invokers.size();
        double minResponse = Double.MAX_VALUE;
        ArrayList<Integer> selectInvokerIndexList = new ArrayList<Integer>(invokers.size());
        for (int i = 0; i < length; ++i) {
            Invoker<T> invoker = invokers.get(i);
            RpcStatus rpcStatus = RpcStatus.getStatus((URL)invoker.getUrl(), (String)invocation.getMethodName());
            Metric metric = this.methodMap.computeIfAbsent(rpcStatus, Metric::new);
            double estimateResponse = metric.getCost();
            if (estimateResponse < minResponse) {
                selectInvokerIndexList.clear();
                selectInvokerIndexList.add(i);
                minResponse = estimateResponse;
                continue;
            }
            if (estimateResponse != minResponse) continue;
            selectInvokerIndexList.add(i);
        }
        return invokers.get((Integer)selectInvokerIndexList.get(ThreadLocalRandom.current().nextInt(selectInvokerIndexList.size())));
    }

    protected static class Metric {
        private volatile long lastUpdateTime;
        private volatile double cost;
        private RpcStatus rpcStatus;
        private long succeededOffset;
        private long succeededElapsedOffset;
        ReentrantLock ewmaLock = new ReentrantLock();

        public Metric(RpcStatus rpcStatus) {
            this.rpcStatus = rpcStatus;
            this.lastUpdateTime = System.currentTimeMillis();
            this.cost = 0.0;
            this.succeededOffset = 0L;
            this.succeededElapsedOffset = 0L;
        }

        private void observe() {
            double rtt = 0.0;
            long succeed = this.rpcStatus.getSucceeded() - this.succeededOffset;
            if (succeed != 0L) {
                rtt = ((double)this.rpcStatus.getSucceededElapsed() * 1.0 - (double)this.succeededElapsedOffset) / (double)succeed;
            }
            long currentTime = System.currentTimeMillis();
            long td = Math.max(currentTime - this.lastUpdateTime, 0L);
            double w = Math.exp((double)(-td) / decayTime);
            this.cost = rtt > this.cost ? rtt : this.cost * w + rtt * (1.0 - w);
            this.lastUpdateTime = currentTime;
            this.succeededOffset = this.rpcStatus.getSucceeded();
            this.succeededElapsedOffset = this.rpcStatus.getSucceededElapsed();
        }

        private double getCost() {
            this.ewmaLock.lock();
            this.observe();
            int active = this.rpcStatus.getActive();
            this.ewmaLock.unlock();
            return this.cost == 0.0 && active != 0 ? 1.40737488355327E14 + (double)active : this.cost * (double)(active + 1);
        }
    }
}

