/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.observability.autoconfigure.exporter.zipkin;

import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.dubbo.config.nested.ExporterConfig;
import org.apache.dubbo.spring.boot.autoconfigure.DubboConfigurationProperties;
import org.apache.dubbo.spring.boot.observability.autoconfigure.exporter.zipkin.ZipkinRestTemplateSender;
import org.apache.dubbo.spring.boot.observability.autoconfigure.exporter.zipkin.ZipkinWebClientSender;
import org.apache.dubbo.spring.boot.observability.autoconfigure.exporter.zipkin.customizer.ZipkinRestTemplateBuilderCustomizer;
import org.apache.dubbo.spring.boot.observability.autoconfigure.exporter.zipkin.customizer.ZipkinWebClientBuilderCustomizer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.brave.ZipkinSpanHandler;
import zipkin2.reporter.urlconnection.URLConnectionSender;

class ZipkinConfigurations {
    ZipkinConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ZipkinSpanExporter.class})
    @ConditionalOnProperty(prefix="dubbo.tracing.tracing-exporter.zipkin-config", name={"endpoint"})
    @EnableConfigurationProperties(value={DubboConfigurationProperties.class})
    static class OpenTelemetryConfiguration {
        OpenTelemetryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ZipkinSpanExporter zipkinSpanExporter(DubboConfigurationProperties properties, BytesEncoder<Span> encoder, ObjectProvider<Sender> senders) {
            AtomicReference senderRef = new AtomicReference();
            senders.orderedStream().findFirst().ifPresent(senderRef::set);
            Sender sender = (Sender)senderRef.get();
            if (sender == null) {
                ExporterConfig.ZipkinConfig zipkinConfig = properties.getTracing().getTracingExporter().getZipkinConfig();
                return ZipkinSpanExporter.builder().setEncoder(encoder).setEndpoint(zipkinConfig.getEndpoint()).setReadTimeout(zipkinConfig.getReadTimeout()).build();
            }
            return ZipkinSpanExporter.builder().setEncoder(encoder).setSender(sender).build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ZipkinSpanHandler.class})
    static class BraveConfiguration {
        BraveConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={Reporter.class})
        ZipkinSpanHandler zipkinSpanHandler(Reporter<Span> spanReporter) {
            return (ZipkinSpanHandler)ZipkinSpanHandler.newBuilder(spanReporter).build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ReporterConfiguration {
        ReporterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={Sender.class})
        AsyncReporter<Span> spanReporter(Sender sender, BytesEncoder<Span> encoder) {
            return AsyncReporter.builder((Sender)sender).build((zipkin2.reporter.BytesEncoder)encoder);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebClient.class})
    @EnableConfigurationProperties(value={DubboConfigurationProperties.class})
    static class WebClientSenderConfiguration {
        WebClientSenderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Sender.class})
        ZipkinWebClientSender webClientSender(DubboConfigurationProperties properties, ObjectProvider<ZipkinWebClientBuilderCustomizer> customizers) {
            ExporterConfig.ZipkinConfig zipkinConfig = properties.getTracing().getTracingExporter().getZipkinConfig();
            WebClient.Builder builder = WebClient.builder();
            customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return new ZipkinWebClientSender(zipkinConfig.getEndpoint(), builder.build());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RestTemplate.class})
    @EnableConfigurationProperties(value={DubboConfigurationProperties.class})
    static class RestTemplateSenderConfiguration {
        RestTemplateSenderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Sender.class})
        ZipkinRestTemplateSender restTemplateSender(DubboConfigurationProperties properties, ObjectProvider<ZipkinRestTemplateBuilderCustomizer> customizers) {
            ExporterConfig.ZipkinConfig zipkinConfig = properties.getTracing().getTracingExporter().getZipkinConfig();
            RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(zipkinConfig.getConnectTimeout()).setReadTimeout(zipkinConfig.getReadTimeout());
            restTemplateBuilder = this.applyCustomizers(restTemplateBuilder, customizers);
            return new ZipkinRestTemplateSender(zipkinConfig.getEndpoint(), restTemplateBuilder.build());
        }

        private RestTemplateBuilder applyCustomizers(RestTemplateBuilder restTemplateBuilder, ObjectProvider<ZipkinRestTemplateBuilderCustomizer> customizers) {
            Iterable orderedCustomizers = () -> customizers.orderedStream().iterator();
            RestTemplateBuilder currentBuilder = restTemplateBuilder;
            for (ZipkinRestTemplateBuilderCustomizer customizer : orderedCustomizers) {
                currentBuilder = customizer.customize(currentBuilder);
            }
            return currentBuilder;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={URLConnectionSender.class})
    @EnableConfigurationProperties(value={DubboConfigurationProperties.class})
    static class UrlConnectionSenderConfiguration {
        UrlConnectionSenderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Sender.class})
        URLConnectionSender urlConnectionSender(DubboConfigurationProperties properties) {
            URLConnectionSender.Builder builder = URLConnectionSender.newBuilder();
            ExporterConfig.ZipkinConfig zipkinConfig = properties.getTracing().getTracingExporter().getZipkinConfig();
            builder.connectTimeout((int)zipkinConfig.getConnectTimeout().toMillis());
            builder.readTimeout((int)zipkinConfig.getReadTimeout().toMillis());
            builder.endpoint(zipkinConfig.getEndpoint());
            return builder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="dubbo.tracing.tracing-exporter.zipkin-config", name={"endpoint"})
    @Import(value={UrlConnectionSenderConfiguration.class, WebClientSenderConfiguration.class, RestTemplateSenderConfiguration.class})
    static class SenderConfiguration {
        SenderConfiguration() {
        }
    }
}

